/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class BoundedColumnValuePartitionFunction
implements PartitionFunction {
    private static final int DEFAULT_PARTITION_ID = 0;
    private static final String NAME = "BoundedColumnValue";
    private static final String COLUMN_VALUES = "columnValues";
    private static final String COLUMN_VALUES_DELIMITER = "columnValuesDelimiter";
    private final int _numPartitions;
    private final Map<String, String> _functionConfig;
    private final String[] _values;

    public BoundedColumnValuePartitionFunction(int numPartitions, Map<String, String> functionConfig) {
        Preconditions.checkArgument((functionConfig != null && functionConfig.size() > 0 ? 1 : 0) != 0, (String)"'functionConfig' should be present, specified", functionConfig);
        Preconditions.checkState((functionConfig.get(COLUMN_VALUES) != null ? 1 : 0) != 0, (Object)"columnValues must be configured");
        Preconditions.checkState((functionConfig.get(COLUMN_VALUES_DELIMITER) != null ? 1 : 0) != 0, (Object)"'columnValuesDelimiter' must be configured");
        this._functionConfig = functionConfig;
        this._values = StringUtils.split((String)functionConfig.get(COLUMN_VALUES), (String)functionConfig.get(COLUMN_VALUES_DELIMITER));
        Preconditions.checkState((numPartitions == this._values.length + 1 ? 1 : 0) != 0, (Object)"'numPartitions' must just be one greater than number of column values configured");
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(Object value) {
        for (int i = 0; i < this._numPartitions - 1; ++i) {
            if (!this._values[i].equalsIgnoreCase(value.toString())) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    @Override
    public Map<String, String> getFunctionConfig() {
        return this._functionConfig;
    }

    public String toString() {
        return this.getName();
    }
}

