/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator;

import java.io.File;
import java.util.Objects;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.spi.data.FieldSpec;

public interface IndexCreationContext {
    public FieldSpec getFieldSpec();

    public File getIndexDir();

    public boolean isOnHeap();

    public int getLengthOfLongestEntry();

    public int getMaxNumberOfMultiValueElements();

    public int getMaxRowLengthInBytes();

    public boolean isSorted();

    public int getCardinality();

    public int getTotalNumberOfEntries();

    public int getTotalDocs();

    public boolean hasDictionary();

    public Comparable<?> getMinValue();

    public Comparable<?> getMaxValue();

    public boolean forwardIndexDisabled();

    public Object getSortedUniqueElementsArray();

    public boolean isOptimizeDictionary();

    public boolean isFixedLength();

    public boolean isTextCommitOnClose();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Common
    implements IndexCreationContext {
        private final File _indexDir;
        private final int _lengthOfLongestEntry;
        private final int _maxNumberOfMultiValueElements;
        private final int _maxRowLengthInBytes;
        private final boolean _onHeap;
        private final FieldSpec _fieldSpec;
        private final boolean _sorted;
        private final int _cardinality;
        private final int _totalNumberOfEntries;
        private final int _totalDocs;
        private final boolean _hasDictionary;
        private final Comparable<?> _minValue;
        private final Comparable<?> _maxValue;
        private final boolean _forwardIndexDisabled;
        private final Object _sortedUniqueElementsArray;
        private final boolean _optimizeDictionary;
        private final boolean _fixedLength;
        private final boolean _textCommitOnClose;

        public Common(File indexDir, int lengthOfLongestEntry, int maxNumberOfMultiValueElements, int maxRowLengthInBytes, boolean onHeap, FieldSpec fieldSpec, boolean sorted, int cardinality, int totalNumberOfEntries, int totalDocs, boolean hasDictionary, Comparable<?> minValue, Comparable<?> maxValue, boolean forwardIndexDisabled, Object sortedUniqueElementsArray, boolean optimizeDictionary, boolean fixedLength, boolean textCommitOnClose) {
            this._indexDir = indexDir;
            this._lengthOfLongestEntry = lengthOfLongestEntry;
            this._maxNumberOfMultiValueElements = maxNumberOfMultiValueElements;
            this._maxRowLengthInBytes = maxRowLengthInBytes;
            this._onHeap = onHeap;
            this._fieldSpec = fieldSpec;
            this._sorted = sorted;
            this._cardinality = cardinality;
            this._totalNumberOfEntries = totalNumberOfEntries;
            this._totalDocs = totalDocs;
            this._hasDictionary = hasDictionary;
            this._minValue = minValue;
            this._maxValue = maxValue;
            this._forwardIndexDisabled = forwardIndexDisabled;
            this._sortedUniqueElementsArray = sortedUniqueElementsArray;
            this._optimizeDictionary = optimizeDictionary;
            this._fixedLength = fixedLength;
            this._textCommitOnClose = textCommitOnClose;
        }

        @Override
        public FieldSpec getFieldSpec() {
            return this._fieldSpec;
        }

        @Override
        public File getIndexDir() {
            return this._indexDir;
        }

        @Override
        public boolean isOnHeap() {
            return this._onHeap;
        }

        @Override
        public int getLengthOfLongestEntry() {
            return this._lengthOfLongestEntry;
        }

        @Override
        public int getMaxNumberOfMultiValueElements() {
            return this._maxNumberOfMultiValueElements;
        }

        @Override
        public int getMaxRowLengthInBytes() {
            return this._maxRowLengthInBytes;
        }

        @Override
        public boolean isSorted() {
            return this._sorted;
        }

        @Override
        public int getCardinality() {
            return this._cardinality;
        }

        @Override
        public int getTotalNumberOfEntries() {
            return this._totalNumberOfEntries;
        }

        @Override
        public int getTotalDocs() {
            return this._totalDocs;
        }

        @Override
        public boolean hasDictionary() {
            return this._hasDictionary;
        }

        @Override
        public Comparable<?> getMinValue() {
            return this._minValue;
        }

        @Override
        public Comparable<?> getMaxValue() {
            return this._maxValue;
        }

        @Override
        public boolean forwardIndexDisabled() {
            return this._forwardIndexDisabled;
        }

        @Override
        public Object getSortedUniqueElementsArray() {
            return this._sortedUniqueElementsArray;
        }

        @Override
        public boolean isOptimizeDictionary() {
            return this._optimizeDictionary;
        }

        @Override
        public boolean isFixedLength() {
            return this._fixedLength;
        }

        @Override
        public boolean isTextCommitOnClose() {
            return this._textCommitOnClose;
        }
    }

    public static final class Builder {
        private File _indexDir;
        private int _lengthOfLongestEntry;
        private int _maxNumberOfMultiValueElements;
        private int _maxRowLengthInBytes;
        private boolean _onHeap = false;
        private FieldSpec _fieldSpec;
        private boolean _sorted;
        private int _cardinality;
        private int _totalNumberOfEntries;
        private int _totalDocs;
        private boolean _hasDictionary = true;
        private Comparable<?> _minValue;
        private Comparable<?> _maxValue;
        private boolean _forwardIndexDisabled;
        private Object _sortedUniqueElementsArray;
        private boolean _optimizedDictionary;
        private boolean _fixedLength;
        private boolean _textCommitOnClose;

        public Builder withColumnIndexCreationInfo(ColumnIndexCreationInfo columnIndexCreationInfo) {
            return this.withLengthOfLongestEntry(columnIndexCreationInfo.getLengthOfLongestEntry()).withMaxNumberOfMultiValueElements(columnIndexCreationInfo.getMaxNumberOfMultiValueElements()).withMaxRowLengthInBytes(columnIndexCreationInfo.getMaxRowLengthInBytes()).withMinValue((Comparable)columnIndexCreationInfo.getMin()).withMaxValue((Comparable)columnIndexCreationInfo.getMax()).withTotalNumberOfEntries(columnIndexCreationInfo.getTotalNumberOfEntries()).withSortedUniqueElementsArray(columnIndexCreationInfo.getSortedUniqueElementsArray()).withCardinality(columnIndexCreationInfo.getDistinctValueCount()).withFixedLength(columnIndexCreationInfo.isFixedLength()).sorted(columnIndexCreationInfo.isSorted());
        }

        public Builder withIndexDir(File indexDir) {
            this._indexDir = indexDir;
            return this;
        }

        public Builder onHeap(boolean onHeap) {
            this._onHeap = onHeap;
            return this;
        }

        public Builder withColumnMetadata(ColumnMetadata columnMetadata) {
            return this.withFieldSpec(columnMetadata.getFieldSpec()).sorted(columnMetadata.isSorted()).withCardinality(columnMetadata.getCardinality()).withTotalNumberOfEntries(columnMetadata.getTotalNumberOfEntries()).withTotalDocs(columnMetadata.getTotalDocs()).withDictionary(columnMetadata.hasDictionary()).withMinValue(columnMetadata.getMinValue()).withMaxValue(columnMetadata.getMaxValue()).withMaxNumberOfMultiValueElements(columnMetadata.getMaxNumberOfMultiValues());
        }

        public Builder withOptimizedDictionary(boolean optimized) {
            this._optimizedDictionary = optimized;
            return this;
        }

        public Builder withFixedLength(boolean fixedLength) {
            this._fixedLength = fixedLength;
            return this;
        }

        public Builder withLengthOfLongestEntry(int lengthOfLongestEntry) {
            this._lengthOfLongestEntry = lengthOfLongestEntry;
            return this;
        }

        public Builder withMaxNumberOfMultiValueElements(int maxNumberOfMultiValueElements) {
            this._maxNumberOfMultiValueElements = maxNumberOfMultiValueElements;
            return this;
        }

        public Builder withMaxRowLengthInBytes(int maxRowLengthInBytes) {
            this._maxRowLengthInBytes = maxRowLengthInBytes;
            return this;
        }

        public Builder withFieldSpec(FieldSpec fieldSpec) {
            this._fieldSpec = fieldSpec;
            return this;
        }

        public Builder sorted(boolean sorted) {
            this._sorted = sorted;
            return this;
        }

        public Builder withCardinality(int cardinality) {
            this._cardinality = cardinality;
            return this;
        }

        public Builder withTotalNumberOfEntries(int totalNumberOfEntries) {
            this._totalNumberOfEntries = totalNumberOfEntries;
            return this;
        }

        public Builder withTotalDocs(int totalDocs) {
            this._totalDocs = totalDocs;
            return this;
        }

        public Builder withDictionary(boolean hasDictionary) {
            this._hasDictionary = hasDictionary;
            return this;
        }

        public Builder withMinValue(Comparable<?> minValue) {
            this._minValue = minValue;
            return this;
        }

        public Builder withMaxValue(Comparable<?> maxValue) {
            this._maxValue = maxValue;
            return this;
        }

        public Builder withForwardIndexDisabled(boolean forwardIndexDisabled) {
            this._forwardIndexDisabled = forwardIndexDisabled;
            return this;
        }

        public Builder withTextCommitOnClose(boolean textCommitOnClose) {
            this._textCommitOnClose = textCommitOnClose;
            return this;
        }

        public Common build() {
            return new Common(Objects.requireNonNull(this._indexDir), this._lengthOfLongestEntry, this._maxNumberOfMultiValueElements, this._maxRowLengthInBytes, this._onHeap, Objects.requireNonNull(this._fieldSpec), this._sorted, this._cardinality, this._totalNumberOfEntries, this._totalDocs, this._hasDictionary, this._minValue, this._maxValue, this._forwardIndexDisabled, this._sortedUniqueElementsArray, this._optimizedDictionary, this._fixedLength, this._textCommitOnClose);
        }

        public Builder withSortedUniqueElementsArray(Object sortedUniqueElementsArray) {
            this._sortedUniqueElementsArray = sortedUniqueElementsArray;
            return this;
        }
    }
}

