/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.IndexConfig;

public class DictionaryIndexConfig
extends IndexConfig {
    public static final DictionaryIndexConfig DEFAULT = new DictionaryIndexConfig(false, false, false);
    public static final DictionaryIndexConfig DISABLED = new DictionaryIndexConfig(true, false, false);
    private final boolean _onHeap;
    private final boolean _useVarLengthDictionary;

    public DictionaryIndexConfig(Boolean onHeap, @Nullable Boolean useVarLengthDictionary) {
        this(false, onHeap, useVarLengthDictionary);
    }

    @JsonCreator
    public DictionaryIndexConfig(@JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="onHeap") Boolean onHeap, @JsonProperty(value="useVarLengthDictionary") @Nullable Boolean useVarLengthDictionary) {
        super(disabled);
        this._onHeap = onHeap != null && onHeap != false;
        this._useVarLengthDictionary = Boolean.TRUE.equals(useVarLengthDictionary);
    }

    public static DictionaryIndexConfig disabled() {
        return DISABLED;
    }

    public boolean isOnHeap() {
        return this._onHeap;
    }

    public boolean getUseVarLengthDictionary() {
        return this._useVarLengthDictionary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DictionaryIndexConfig that = (DictionaryIndexConfig)((Object)o);
        return this._onHeap == that._onHeap && this._useVarLengthDictionary == that._useVarLengthDictionary;
    }

    public int hashCode() {
        return Objects.hash(this._onHeap, this._useVarLengthDictionary);
    }

    public String toString() {
        if (this.isEnabled()) {
            return "DictionaryIndexConfig{\"onHeap\":" + this._onHeap + ", \"useVarLengthDictionary\":" + this._useVarLengthDictionary + "}";
        }
        return "DictionaryIndexConfig{\"disabled\": true}";
    }
}

