/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.utils.JsonUtils;

public class ForwardIndexConfig
extends IndexConfig {
    public static final int DEFAULT_RAW_WRITER_VERSION = 2;
    public static final ForwardIndexConfig DISABLED = new ForwardIndexConfig(true, null, null, null);
    public static final ForwardIndexConfig DEFAULT = new Builder().build();
    @Nullable
    private final ChunkCompressionType _chunkCompressionType;
    private final boolean _deriveNumDocsPerChunk;
    private final int _rawIndexWriterVersion;

    @JsonCreator
    public ForwardIndexConfig(@Nullable @JsonProperty(value="disabled") Boolean disabled, @Nullable @JsonProperty(value="chunkCompressionType") ChunkCompressionType chunkCompressionType, @JsonProperty(value="deriveNumDocsPerChunk") Boolean deriveNumDocsPerChunk, @JsonProperty(value="rawIndexWriterVersion") Integer rawIndexWriterVersion) {
        super(disabled);
        this._chunkCompressionType = chunkCompressionType;
        this._deriveNumDocsPerChunk = deriveNumDocsPerChunk != null && deriveNumDocsPerChunk != false;
        this._rawIndexWriterVersion = rawIndexWriterVersion == null ? 2 : rawIndexWriterVersion;
    }

    @Nullable
    public ChunkCompressionType getChunkCompressionType() {
        return this._chunkCompressionType;
    }

    public boolean isDeriveNumDocsPerChunk() {
        return this._deriveNumDocsPerChunk;
    }

    public int getRawIndexWriterVersion() {
        return this._rawIndexWriterVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForwardIndexConfig that = (ForwardIndexConfig)((Object)o);
        return this._deriveNumDocsPerChunk == that._deriveNumDocsPerChunk && this._rawIndexWriterVersion == that._rawIndexWriterVersion && this._chunkCompressionType == that._chunkCompressionType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this._chunkCompressionType, this._deriveNumDocsPerChunk, this._rawIndexWriterVersion});
    }

    public String toString() {
        try {
            return JsonUtils.objectToString((Object)((Object)this));
        }
        catch (IOException ex) {
            return "{\"chunkCompressionType\":" + this._chunkCompressionType + ", \"deriveNumDocsPerChunk\":" + this._deriveNumDocsPerChunk + ", \"rawIndexWriterVersion\":" + this._rawIndexWriterVersion + "}";
        }
    }

    public static class Builder {
        @Nullable
        private ChunkCompressionType _chunkCompressionType;
        private boolean _deriveNumDocsPerChunk = false;
        private int _rawIndexWriterVersion = 2;

        public Builder() {
        }

        public Builder(ForwardIndexConfig other) {
            this._chunkCompressionType = other.getChunkCompressionType();
            this._deriveNumDocsPerChunk = other._deriveNumDocsPerChunk;
            this._rawIndexWriterVersion = other._rawIndexWriterVersion;
        }

        public Builder withCompressionType(ChunkCompressionType chunkCompressionType) {
            this._chunkCompressionType = chunkCompressionType;
            return this;
        }

        public Builder withDeriveNumDocsPerChunk(boolean deriveNumDocsPerChunk) {
            this._deriveNumDocsPerChunk = deriveNumDocsPerChunk;
            return this;
        }

        public Builder withRawIndexWriterVersion(int rawIndexWriterVersion) {
            this._rawIndexWriterVersion = rawIndexWriterVersion;
            return this;
        }

        public Builder withLegacyProperties(Map<String, Map<String, String>> propertiesByCol, String colName) {
            Map<String, String> colProps;
            if (propertiesByCol != null && (colProps = propertiesByCol.get(colName)) != null) {
                this.withLegacyProperties(colProps);
            }
            return this;
        }

        public Builder withLegacyProperties(Map<String, String> properties) {
            String newRawIndexVersion;
            String newDerive = properties.get("deriveNumDocsPerChunkForRawIndex");
            if (newDerive != null) {
                this.withDeriveNumDocsPerChunk(Boolean.parseBoolean(newDerive));
            }
            if ((newRawIndexVersion = properties.get("rawIndexWriterVersion")) != null) {
                this.withRawIndexWriterVersion(Integer.parseInt(newRawIndexVersion));
            }
            return this;
        }

        public ForwardIndexConfig build() {
            return new ForwardIndexConfig(false, this._chunkCompressionType, this._deriveNumDocsPerChunk, this._rawIndexWriterVersion);
        }
    }
}

