/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexCreator;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.mutable.MutableIndex;
import org.apache.pinot.segment.spi.index.mutable.provider.MutableIndexContext;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public interface IndexType<C extends IndexConfig, IR extends IndexReader, IC extends IndexCreator> {
    public String getId();

    public Class<C> getIndexConfigClass();

    public C getDefaultConfig();

    public Map<String, C> getConfig(TableConfig var1, Schema var2);

    default public String getPrettyName() {
        return this.getId();
    }

    public IC createIndexCreator(IndexCreationContext var1, C var2) throws Exception;

    public IndexReaderFactory<IR> getReaderFactory();

    @Nullable
    default public IR getIndexReader(ColumnIndexContainer indexContainer) {
        return (IR)indexContainer.getIndex(this);
    }

    public String getFileExtension(ColumnMetadata var1);

    public IndexHandler createIndexHandler(SegmentDirectory var1, Map<String, FieldIndexConfigs> var2, @Nullable Schema var3, @Nullable TableConfig var4);

    public void convertToNewFormat(TableConfig var1, Schema var2);

    @Nullable
    default public MutableIndex createMutableIndex(MutableIndexContext context, C config) {
        return null;
    }
}

