/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class MergedColumnConfigDeserializer<C>
implements ColumnConfigDeserializer<C> {
    private final OnConflict _onConflict;
    private final Iterable<ColumnConfigDeserializer<C>> _deserializers;

    @SafeVarargs
    public MergedColumnConfigDeserializer(OnConflict onConflict, ColumnConfigDeserializer<C> ... deserializers) {
        this(onConflict, Arrays.asList(deserializers));
    }

    public MergedColumnConfigDeserializer(OnConflict onConflict, Iterable<ColumnConfigDeserializer<C>> deserializers) {
        this._onConflict = onConflict;
        this._deserializers = deserializers;
    }

    @Override
    public Map<String, C> deserialize(TableConfig tableConfig, Schema schema) {
        HashMap<String, C> result = new HashMap<String, C>();
        for (ColumnConfigDeserializer<C> deserializer : this._deserializers) {
            Map<String, C> partialResult = deserializer.deserialize(tableConfig, schema);
            for (Map.Entry<String, C> entry : partialResult.entrySet()) {
                String column = entry.getKey();
                if (result.containsKey(column)) {
                    this._onConflict.merge(result, column, entry.getValue());
                    continue;
                }
                result.put(column, entry.getValue());
            }
        }
        return result;
    }

    public static enum OnConflict {
        FAIL{

            @Override
            public <C> void merge(Map<String, C> map, String column, C newValue) {
                throw new ConfigDeclaredTwiceException(column);
            }
        }
        ,
        PICK_FIRST{

            @Override
            public <C> void merge(Map<String, C> map, String column, C newValue) {
            }
        }
        ,
        PICK_LAST{

            @Override
            public <C> void merge(Map<String, C> map, String column, C newValue) {
                map.put(column, newValue);
            }
        };


        public abstract <C> void merge(Map<String, C> var1, String var2, C var3);
    }

    public static class ConfigDeclaredTwiceException
    extends RuntimeException {
        private final String _column;

        public ConfigDeclaredTwiceException(String column) {
            super("Configuration is declared in two different ways for column " + column);
            this._column = column;
        }

        public String getColumn() {
            return this._column;
        }
    }
}

