/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.FstIndexConfig;
import org.apache.pinot.segment.spi.index.IndexService;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.RangeIndexConfig;
import org.apache.pinot.segment.spi.index.TextIndexConfig;
import org.apache.pinot.segment.spi.index.creator.BloomFilterCreator;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.FSTIndexCreator;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.JsonIndexConfig;

public class StandardIndexes {
    public static final String FORWARD_ID = "forward_index";
    public static final String DICTIONARY_ID = "dictionary";
    public static final String NULL_VALUE_VECTOR_ID = "nullvalue_vector";
    public static final String BLOOM_FILTER_ID = "bloom_filter";
    public static final String FST_ID = "fst_index";
    public static final String INVERTED_ID = "inverted_index";
    public static final String JSON_ID = "json_index";
    public static final String RANGE_ID = "range_index";
    public static final String TEXT_ID = "text_index";
    public static final String H3_ID = "h3_index";

    private StandardIndexes() {
    }

    public static IndexType<ForwardIndexConfig, ForwardIndexReader, ForwardIndexCreator> forward() {
        return IndexService.getInstance().get(FORWARD_ID);
    }

    public static IndexType<DictionaryIndexConfig, Dictionary, ?> dictionary() {
        return IndexService.getInstance().get(DICTIONARY_ID);
    }

    public static IndexType<IndexConfig, NullValueVectorReader, ?> nullValueVector() {
        return IndexService.getInstance().get(NULL_VALUE_VECTOR_ID);
    }

    public static IndexType<BloomFilterConfig, BloomFilterReader, BloomFilterCreator> bloomFilter() {
        return IndexService.getInstance().get(BLOOM_FILTER_ID);
    }

    public static IndexType<FstIndexConfig, TextIndexReader, FSTIndexCreator> fst() {
        return IndexService.getInstance().get(FST_ID);
    }

    public static IndexType<IndexConfig, InvertedIndexReader, DictionaryBasedInvertedIndexCreator> inverted() {
        return IndexService.getInstance().get(INVERTED_ID);
    }

    public static IndexType<JsonIndexConfig, JsonIndexReader, JsonIndexCreator> json() {
        return IndexService.getInstance().get(JSON_ID);
    }

    public static IndexType<RangeIndexConfig, RangeIndexReader, CombinedInvertedIndexCreator> range() {
        return IndexService.getInstance().get(RANGE_ID);
    }

    public static IndexType<TextIndexConfig, TextIndexReader, TextIndexCreator> text() {
        return IndexService.getInstance().get(TEXT_ID);
    }

    public static IndexType<H3IndexConfig, H3IndexReader, GeoSpatialIndexCreator> h3() {
        return IndexService.getInstance().get(H3_ID);
    }
}

