/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.config.table.IndexConfig;

public class TextIndexConfig
extends IndexConfig {
    private static final int LUCENE_INDEX_DEFAULT_MAX_BUFFER_SIZE_MB = 500;
    private static final boolean LUCENE_INDEX_DEFAULT_USE_COMPOUND_FILE = true;
    public static final TextIndexConfig DISABLED = new TextIndexConfig(true, null, null, false, false, Collections.emptyList(), Collections.emptyList(), false, 500);
    private final FSTType _fstType;
    @Nullable
    private final Object _rawValueForTextIndex;
    private final boolean _enableQueryCache;
    private final boolean _useANDForMultiTermQueries;
    private final List<String> _stopWordsInclude;
    private final List<String> _stopWordsExclude;
    private final boolean _luceneUseCompoundFile;
    private final int _luceneMaxBufferSizeMB;

    @JsonCreator
    public TextIndexConfig(@JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="fst") FSTType fstType, @JsonProperty(value="rawValue") @Nullable Object rawValueForTextIndex, @JsonProperty(value="queryCache") boolean enableQueryCache, @JsonProperty(value="useANDForMultiTermQueries") boolean useANDForMultiTermQueries, @JsonProperty(value="stopWordsInclude") List<String> stopWordsInclude, @JsonProperty(value="stopWordsExclude") List<String> stopWordsExclude, @JsonProperty(value="luceneUseCompoundFile") Boolean luceneUseCompoundFile, @JsonProperty(value="luceneMaxBufferSizeMB") Integer luceneMaxBufferSizeMB) {
        super(disabled);
        this._fstType = fstType;
        this._rawValueForTextIndex = rawValueForTextIndex;
        this._enableQueryCache = enableQueryCache;
        this._useANDForMultiTermQueries = useANDForMultiTermQueries;
        this._stopWordsInclude = stopWordsInclude;
        this._stopWordsExclude = stopWordsExclude;
        this._luceneUseCompoundFile = luceneUseCompoundFile == null ? true : luceneUseCompoundFile;
        this._luceneMaxBufferSizeMB = luceneMaxBufferSizeMB == null ? 500 : luceneMaxBufferSizeMB;
    }

    public FSTType getFstType() {
        return this._fstType;
    }

    @Nullable
    public Object getRawValueForTextIndex() {
        return this._rawValueForTextIndex;
    }

    public boolean isEnableQueryCache() {
        return this._enableQueryCache;
    }

    public boolean isUseANDForMultiTermQueries() {
        return this._useANDForMultiTermQueries;
    }

    public List<String> getStopWordsInclude() {
        return this._stopWordsInclude;
    }

    public List<String> getStopWordsExclude() {
        return this._stopWordsExclude;
    }

    public boolean isLuceneUseCompoundFile() {
        return this._luceneUseCompoundFile;
    }

    public int getLuceneMaxBufferSizeMB() {
        return this._luceneMaxBufferSizeMB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextIndexConfig that = (TextIndexConfig)((Object)o);
        return this._enableQueryCache == that._enableQueryCache && this._useANDForMultiTermQueries == that._useANDForMultiTermQueries && this._fstType == that._fstType && Objects.equals(this._rawValueForTextIndex, that._rawValueForTextIndex) && Objects.equals(this._stopWordsInclude, that._stopWordsInclude) && Objects.equals(this._stopWordsExclude, that._stopWordsExclude) && this._luceneUseCompoundFile == that._luceneUseCompoundFile && this._luceneMaxBufferSizeMB == that._luceneMaxBufferSizeMB;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this._fstType, this._rawValueForTextIndex, this._enableQueryCache, this._useANDForMultiTermQueries, this._stopWordsInclude, this._stopWordsExclude, this._luceneUseCompoundFile, this._luceneMaxBufferSizeMB);
    }

    public static abstract class AbstractBuilder {
        @Nullable
        protected FSTType _fstType;
        @Nullable
        protected Object _rawValueForTextIndex;
        protected boolean _enableQueryCache = false;
        protected boolean _useANDForMultiTermQueries = true;
        protected List<String> _stopWordsInclude = new ArrayList<String>();
        protected List<String> _stopWordsExclude = new ArrayList<String>();
        protected boolean _luceneUseCompoundFile = true;
        protected int _luceneMaxBufferSizeMB = 500;

        public AbstractBuilder(@Nullable FSTType fstType) {
            this._fstType = fstType;
        }

        public AbstractBuilder(TextIndexConfig other) {
            this._fstType = other._fstType;
            this._enableQueryCache = other._enableQueryCache;
            this._useANDForMultiTermQueries = other._useANDForMultiTermQueries;
            this._stopWordsInclude = new ArrayList<String>(other._stopWordsInclude);
            this._stopWordsExclude = new ArrayList<String>(other._stopWordsExclude);
            this._luceneUseCompoundFile = other._luceneUseCompoundFile;
            this._luceneMaxBufferSizeMB = other._luceneMaxBufferSizeMB;
        }

        public TextIndexConfig build() {
            return new TextIndexConfig(false, this._fstType, this._rawValueForTextIndex, this._enableQueryCache, this._useANDForMultiTermQueries, this._stopWordsInclude, this._stopWordsExclude, this._luceneUseCompoundFile, this._luceneMaxBufferSizeMB);
        }

        public abstract AbstractBuilder withProperties(@Nullable Map<String, String> var1);

        public AbstractBuilder withRawValueForTextIndex(@Nullable Object rawValueForTextIndex) {
            this._rawValueForTextIndex = rawValueForTextIndex;
            return this;
        }

        public AbstractBuilder withStopWordsInclude(List<String> stopWordsInclude) {
            this._stopWordsInclude = stopWordsInclude;
            return this;
        }

        public AbstractBuilder withStopWordsExclude(List<String> stopWordsExclude) {
            this._stopWordsExclude = stopWordsExclude;
            return this;
        }

        public AbstractBuilder withLuceneUseCompoundFile(boolean useCompoundFile) {
            this._luceneUseCompoundFile = useCompoundFile;
            return this;
        }

        public AbstractBuilder withLuceneMaxBufferSizeMB(int maxBufferSizeMB) {
            this._luceneMaxBufferSizeMB = maxBufferSizeMB;
            return this;
        }
    }
}

