/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.mutable.provider;

import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;

public class MutableIndexContext {
    private final int _capacity;
    private final FieldSpec _fieldSpec;
    private final int _fixedLengthBytes;
    private final boolean _hasDictionary;
    private final boolean _offHeap;
    private final int _estimatedColSize;
    private final int _estimatedCardinality;
    private final int _avgNumMultiValues;
    private final String _segmentName;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final File _consumerDir;

    public MutableIndexContext(FieldSpec fieldSpec, int fixedLengthBytes, boolean hasDictionary, String segmentName, PinotDataBufferMemoryManager memoryManager, int capacity, boolean offHeap, int estimatedColSize, int estimatedCardinality, int avgNumMultiValues, File consumerDir) {
        this._fieldSpec = fieldSpec;
        this._fixedLengthBytes = fixedLengthBytes;
        this._hasDictionary = hasDictionary;
        this._segmentName = segmentName;
        this._memoryManager = memoryManager;
        this._capacity = capacity;
        this._offHeap = offHeap;
        this._estimatedColSize = estimatedColSize;
        this._estimatedCardinality = estimatedCardinality;
        this._avgNumMultiValues = avgNumMultiValues;
        this._consumerDir = consumerDir;
    }

    public PinotDataBufferMemoryManager getMemoryManager() {
        return this._memoryManager;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public FieldSpec getFieldSpec() {
        return this._fieldSpec;
    }

    public int getFixedLengthBytes() {
        return this._fixedLengthBytes;
    }

    public boolean hasDictionary() {
        return this._hasDictionary;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public boolean isOffHeap() {
        return this._offHeap;
    }

    public int getEstimatedColSize() {
        return this._estimatedColSize;
    }

    public int getEstimatedCardinality() {
        return this._estimatedCardinality;
    }

    public int getAvgNumMultiValues() {
        return this._avgNumMultiValues;
    }

    @Nullable
    public File getConsumerDir() {
        return this._consumerDir;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FieldSpec _fieldSpec;
        private int _fixedLengthBytes;
        private String _segmentName;
        private boolean _hasDictionary = true;
        private boolean _offHeap = true;
        private int _capacity;
        private PinotDataBufferMemoryManager _memoryManager;
        private int _estimatedColSize;
        private int _estimatedCardinality;
        private int _avgNumMultiValues;
        @Nullable
        private File _consumerDir;

        public Builder withMemoryManager(PinotDataBufferMemoryManager memoryManager) {
            this._memoryManager = memoryManager;
            return this;
        }

        public Builder withFieldSpec(FieldSpec fieldSpec) {
            this._fieldSpec = fieldSpec;
            return this;
        }

        public Builder withSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder withDictionary(boolean hasDictionary) {
            this._hasDictionary = hasDictionary;
            return this;
        }

        public Builder offHeap(boolean offHeap) {
            this._offHeap = offHeap;
            return this;
        }

        public Builder withCapacity(int capacity) {
            this._capacity = capacity;
            return this;
        }

        public Builder withEstimatedColSize(int estimatedColSize) {
            this._estimatedColSize = estimatedColSize;
            return this;
        }

        public Builder withEstimatedCardinality(int estimatedCardinality) {
            this._estimatedCardinality = estimatedCardinality;
            return this;
        }

        public Builder withAvgNumMultiValues(int avgNumMultiValues) {
            this._avgNumMultiValues = avgNumMultiValues;
            return this;
        }

        public Builder withConsumerDir(File consumerDir) {
            this._consumerDir = consumerDir;
            return this;
        }

        public Builder withFixedLengthBytes(int fixedLengthBytes) {
            this._fixedLengthBytes = fixedLengthBytes;
            return this;
        }

        public MutableIndexContext build() {
            return new MutableIndexContext(Objects.requireNonNull(this._fieldSpec), this._fixedLengthBytes, this._hasDictionary, Objects.requireNonNull(this._segmentName), Objects.requireNonNull(this._memoryManager), this._capacity, this._offHeap, this._estimatedColSize, this._estimatedCardinality, this._avgNumMultiValues, this._consumerDir);
        }
    }
}

