/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory.unsafe;

import java.io.IOException;
import org.apache.pinot.segment.spi.memory.unsafe.Memory;
import org.apache.pinot.segment.spi.memory.unsafe.Unsafer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectMemory
implements Memory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectMemory.class);
    private final long _address;
    private final long _size;
    private volatile boolean _closed = false;

    public DirectMemory(long size) {
        this._address = Unsafer.UNSAFE.allocateMemory(size);
        this._size = size;
        Unsafer.UNSAFE.setMemory(this._address, this._size, (byte)0);
    }

    @Override
    public long getAddress() {
        return this._address;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this._closed) {
            DirectMemory directMemory = this;
            synchronized (directMemory) {
                if (!this._closed) {
                    Unsafer.UNSAFE.freeMemory(this._address);
                    this._closed = true;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this._closed) {
            LOGGER.warn("Mmap section of " + this._size + " wasn't explicitly closed");
            this.close();
        }
        super.finalize();
    }
}

