/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;

public class IndexConfigDeserializer {
    private IndexConfigDeserializer() {
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> ifIndexingConfig(ColumnConfigDeserializer<C> delegate) {
        return (tableConfig, schema) -> tableConfig.getIndexingConfig() != null ? delegate.deserialize(tableConfig, schema) : Collections.emptyMap();
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> always(C config) {
        return (tableConfig, schema) -> {
            HashMap<String, IndexConfig> result = new HashMap<String, IndexConfig>();
            for (String col : schema.getColumnNames()) {
                result.put(col, config);
            }
            return result;
        };
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> alwaysDefault(IndexType<C, ?, ?> indexType) {
        return IndexConfigDeserializer.always(indexType.getDefaultConfig());
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> alwaysCall(BiFunction<TableConfig, Schema, C> map) {
        return (tableConfig, schema) -> {
            IndexConfig config = (IndexConfig)map.apply(tableConfig, schema);
            HashMap<String, IndexConfig> result = new HashMap<String, IndexConfig>();
            for (String col : schema.getColumnNames()) {
                result.put(col, config);
            }
            return result;
        };
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> fromIndexes(String fieldName, Class<C> aClass) {
        return (tableConfig, schema) -> {
            HashMap<String, IndexConfig> result = new HashMap<String, IndexConfig>();
            List fieldConfigList = tableConfig.getFieldConfigList();
            if (fieldConfigList != null) {
                for (FieldConfig fc : fieldConfigList) {
                    IndexConfig config;
                    JsonNode jsonNode;
                    if (!fc.getIndexes().isObject() || (jsonNode = fc.getIndexes().get(fieldName)) == null) continue;
                    try {
                        config = (IndexConfig)JsonUtils.jsonNodeToObject((JsonNode)jsonNode, (Class)aClass);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    result.put(fc.getName(), config);
                }
            }
            return result;
        };
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> fromIndexTypes(FieldConfig.IndexType configIndexType, BiFunction<TableConfig, FieldConfig, C> mapFunction) {
        return (tableConfig, schema) -> {
            List fieldConfigList = tableConfig.getFieldConfigList();
            if (fieldConfigList == null) {
                return Collections.emptyMap();
            }
            HashMap<String, IndexConfig> result = new HashMap<String, IndexConfig>();
            for (FieldConfig fieldConfig : fieldConfigList) {
                if (!fieldConfig.getIndexTypes().contains(configIndexType)) continue;
                result.put(fieldConfig.getName(), (IndexConfig)mapFunction.apply(tableConfig, fieldConfig));
            }
            return result;
        };
    }

    public static <T, C extends IndexConfig> ColumnConfigDeserializer<C> fromCollection(Function<TableConfig, Collection<T>> extract, BiConsumer<Map<String, C>, T> consume) {
        return (tableConfig, schema) -> {
            Collection col = (Collection)extract.apply(tableConfig);
            if (col == null) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap();
            for (Object temp : col) {
                consume.accept(result, temp);
            }
            return result;
        };
    }

    public static <K, T, C extends IndexConfig> ColumnConfigDeserializer<C> fromMap(Function<TableConfig, Map<K, T>> extract, TriConsumer<K, T, C> consume) {
        return (tableConfig, schema) -> {
            Map map = (Map)extract.apply(tableConfig);
            if (map == null) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                consume.accept(result, entry.getKey(), entry.getValue());
            }
            return result;
        };
    }

    public static <C extends IndexConfig> ColumnConfigDeserializer<C> fromMap(Function<TableConfig, Map<String, C>> extract) {
        return (tableConfig, schema) -> {
            Map result = (Map)extract.apply(tableConfig);
            if (result == null) {
                return Collections.emptyMap();
            }
            return result;
        };
    }

    @FunctionalInterface
    public static interface TriConsumer<K, T, C> {
        public void accept(Map<String, C> var1, K var2, T var3);
    }
}

