/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.reader;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.math.BigDecimal;
import java.util.List;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public interface Dictionary
extends IndexReader {
    public static final int NULL_VALUE_INDEX = -1;

    public boolean isSorted();

    public FieldSpec.DataType getValueType();

    public int length();

    public int indexOf(String var1);

    default public int indexOf(int intValue) {
        throw new UnsupportedOperationException();
    }

    default public int indexOf(long longValue) {
        throw new UnsupportedOperationException();
    }

    default public int indexOf(float floatValue) {
        throw new UnsupportedOperationException();
    }

    default public int indexOf(double doubleValue) {
        throw new UnsupportedOperationException();
    }

    default public int indexOf(BigDecimal bigDecimalValue) {
        throw new UnsupportedOperationException();
    }

    default public int indexOf(ByteArray bytesValue) {
        throw new UnsupportedOperationException();
    }

    public int insertionIndexOf(String var1);

    public IntSet getDictIdsInRange(String var1, String var2, boolean var3, boolean var4);

    public int compare(int var1, int var2);

    public Comparable getMinVal();

    public Comparable getMaxVal();

    public Object getSortedValues();

    public Object get(int var1);

    default public Object getInternal(int dictId) {
        return this.get(dictId);
    }

    public int getIntValue(int var1);

    public long getLongValue(int var1);

    public float getFloatValue(int var1);

    public double getDoubleValue(int var1);

    public BigDecimal getBigDecimalValue(int var1);

    public String getStringValue(int var1);

    default public byte[] getBytesValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    default public ByteArray getByteArrayValue(int dictId) {
        return new ByteArray(this.getBytesValue(dictId));
    }

    default public void readIntValues(int[] dictIds, int length, int[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getIntValue(dictIds[i]);
        }
    }

    default public void readIntValues(int[] dictIds, int length, Integer[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getIntValue(dictIds[i]);
        }
    }

    default public void readLongValues(int[] dictIds, int length, long[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getLongValue(dictIds[i]);
        }
    }

    default public void readLongValues(int[] dictIds, int length, Long[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getLongValue(dictIds[i]);
        }
    }

    default public void readFloatValues(int[] dictIds, int length, float[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getFloatValue(dictIds[i]);
        }
    }

    default public void readFloatValues(int[] dictIds, int length, Float[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = Float.valueOf(this.getFloatValue(dictIds[i]));
        }
    }

    default public void readDoubleValues(int[] dictIds, int length, double[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getDoubleValue(dictIds[i]);
        }
    }

    default public void readDoubleValues(int[] dictIds, int length, Double[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getDoubleValue(dictIds[i]);
        }
    }

    default public void readBigDecimalValues(int[] dictIds, int length, BigDecimal[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getBigDecimalValue(dictIds[i]);
        }
    }

    default public void readStringValues(int[] dictIds, int length, String[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getStringValue(dictIds[i]);
        }
    }

    default public void readBytesValues(int[] dictIds, int length, byte[][] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getBytesValue(dictIds[i]);
        }
    }

    default public void getDictIds(List<String> values, IntSet dictIds) {
        for (String value : values) {
            int dictId = this.indexOf(value);
            if (dictId < 0) continue;
            dictIds.add(dictId);
        }
    }

    default public void getDictIds(List<String> sortedValues, IntSet dictIds, SortedBatchLookupAlgorithm algorithm) {
        this.getDictIds(sortedValues, dictIds);
    }

    public static enum SortedBatchLookupAlgorithm {
        DIVIDE_BINARY_SEARCH,
        SCAN,
        PLAIN_BINARY_SEARCH;

    }
}

