/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.startree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.AggregationSpec;
import org.apache.pinot.spi.config.table.FieldConfig;

public class StarTreeV2Metadata {
    private final int _numDocs;
    private final List<String> _dimensionsSplitOrder;
    private final TreeMap<AggregationFunctionColumnPair, AggregationSpec> _aggregationSpecs;
    private final int _maxLeafRecords;
    private final Set<String> _skipStarNodeCreationForDimensions;

    public StarTreeV2Metadata(Configuration metadataProperties) {
        this._numDocs = metadataProperties.getInt("total.docs");
        this._dimensionsSplitOrder = Arrays.asList(metadataProperties.getStringArray("split.order"));
        this._aggregationSpecs = new TreeMap();
        int numAggregations = metadataProperties.getInt("aggregation.count", 0);
        if (numAggregations > 0) {
            for (int i = 0; i < numAggregations; ++i) {
                Configuration aggregationConfig = metadataProperties.subset("aggregation." + i);
                AggregationFunctionType functionType = AggregationFunctionType.getAggregationFunctionType(aggregationConfig.getString("function.type"));
                String columnName = aggregationConfig.getString("column.name");
                AggregationFunctionColumnPair functionColumnPair = new AggregationFunctionColumnPair(functionType, columnName);
                AggregationFunctionColumnPair storedType = AggregationFunctionColumnPair.resolveToStoredType(functionColumnPair);
                AggregationSpec aggregationSpec = new AggregationSpec((FieldConfig.CompressionCodec)aggregationConfig.getEnum("compression.codec", FieldConfig.CompressionCodec.class, null), aggregationConfig.getBoolean("derive.num.docs.per.chunk", null), aggregationConfig.getInteger("index.version", null), aggregationConfig.getInteger("target.max.chunk.size.bytes", null), aggregationConfig.getInteger("target.docs.per.chunk", null));
                this._aggregationSpecs.putIfAbsent(storedType, aggregationSpec);
            }
        } else {
            for (String functionColumnPairName : metadataProperties.getStringArray("function.column.pairs")) {
                AggregationFunctionColumnPair functionColumnPair = AggregationFunctionColumnPair.fromColumnName(functionColumnPairName);
                AggregationFunctionColumnPair storedType = AggregationFunctionColumnPair.resolveToStoredType(functionColumnPair);
                this._aggregationSpecs.putIfAbsent(storedType, AggregationSpec.DEFAULT);
            }
        }
        this._maxLeafRecords = metadataProperties.getInt("max.leaf.records");
        this._skipStarNodeCreationForDimensions = new HashSet<String>(Arrays.asList(metadataProperties.getStringArray("skip.star.node.creation")));
    }

    public int getNumDocs() {
        return this._numDocs;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    public TreeMap<AggregationFunctionColumnPair, AggregationSpec> getAggregationSpecs() {
        return this._aggregationSpecs;
    }

    public Set<AggregationFunctionColumnPair> getFunctionColumnPairs() {
        return this._aggregationSpecs.keySet();
    }

    public boolean containsFunctionColumnPair(AggregationFunctionColumnPair functionColumnPair) {
        return this._aggregationSpecs.containsKey(functionColumnPair);
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }

    public Set<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }

    public static void writeMetadata(Configuration metadataProperties, int totalDocs, List<String> dimensionsSplitOrder, TreeMap<AggregationFunctionColumnPair, AggregationSpec> aggregationSpecs, int maxLeafRecords, Set<String> skipStarNodeCreationForDimensions) {
        metadataProperties.setProperty("total.docs", (Object)totalDocs);
        metadataProperties.setProperty("split.order", dimensionsSplitOrder);
        metadataProperties.setProperty("function.column.pairs", aggregationSpecs.keySet());
        metadataProperties.setProperty("aggregation.count", (Object)aggregationSpecs.size());
        int index = 0;
        for (Map.Entry<AggregationFunctionColumnPair, AggregationSpec> entry : aggregationSpecs.entrySet()) {
            AggregationFunctionColumnPair functionColumnPair = entry.getKey();
            AggregationSpec aggregationSpec = entry.getValue();
            String prefix = "aggregation." + index + ".";
            metadataProperties.setProperty(prefix + "function.type", (Object)functionColumnPair.getFunctionType().getName());
            metadataProperties.setProperty(prefix + "column.name", (Object)functionColumnPair.getColumn());
            metadataProperties.setProperty(prefix + "compression.codec", (Object)aggregationSpec.getCompressionCodec());
            metadataProperties.setProperty(prefix + "derive.num.docs.per.chunk", (Object)aggregationSpec.isDeriveNumDocsPerChunk());
            metadataProperties.setProperty(prefix + "index.version", (Object)aggregationSpec.getIndexVersion());
            metadataProperties.setProperty(prefix + "target.max.chunk.size.bytes", (Object)aggregationSpec.getTargetMaxChunkSizeBytes());
            metadataProperties.setProperty(prefix + "target.docs.per.chunk", (Object)aggregationSpec.getTargetDocsPerChunk());
            ++index;
        }
        metadataProperties.setProperty("max.leaf.records", (Object)maxLeafRecords);
        metadataProperties.setProperty("skip.star.node.creation", skipStarNodeCreationForDimensions);
    }
}

