/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.memory.PinotBufferFactory;
import org.apache.pinot.segment.spi.memory.PinotByteBuffer;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class ByteBufferPinotBufferFactory
implements PinotBufferFactory {
    @Override
    public PinotDataBuffer allocateDirect(long size, ByteOrder byteOrder) {
        Preconditions.checkArgument((size <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Trying to allocate %s bytes when max is %s", (long)size, (int)Integer.MAX_VALUE);
        return PinotByteBuffer.allocateDirect((int)size, byteOrder);
    }

    @Override
    public PinotDataBuffer readFile(File file, long offset, long size, ByteOrder byteOrder) throws IOException {
        Preconditions.checkArgument((size <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Trying to allocate %s bytes when max is %s", (long)size, (int)Integer.MAX_VALUE);
        return PinotByteBuffer.loadFile(file, offset, (int)size, byteOrder);
    }

    @Override
    public PinotDataBuffer mapFile(File file, boolean readOnly, long offset, long size, ByteOrder byteOrder) throws IOException {
        Preconditions.checkArgument((size <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Trying to allocate {} bytes when max is {}", (long)size, (int)Integer.MAX_VALUE);
        return PinotByteBuffer.mapFile(file, readOnly, offset, (int)size, byteOrder);
    }
}

