/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.memory;

import com.google.common.primitives.Longs;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.pinot.segment.spi.memory.DataBuffer;

public abstract class PinotOutputStream
extends OutputStream
implements DataOutput {
    public abstract long getCurrentOffset();

    public abstract void seek(long var1);

    public void moveCurrentOffset(long change) {
        long newOffset = this.getCurrentOffset() + change;
        this.seek(newOffset);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.write(0xFF & v >> 24);
        this.write(0xFF & v >> 16);
        this.write(0xFF & v >> 8);
        this.write(0xFF & v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        byte[] bytes = Longs.toByteArray((long)v);
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(0xFF & v >> 8);
        this.write(0xFF & v);
    }

    public void writeInt4String(String v) throws IOException {
        this.writeInt(v.length());
        this.write(v.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        new DataOutputStream(this).writeBytes(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        new DataOutputStream(this).writeUTF(s);
    }

    public void write(DataBuffer input) throws IOException {
        this.write(input, 0L, input.size());
    }

    public void write(DataBuffer input, long offset, long length) throws IOException {
        int bytesToRead;
        byte[] bytes = new byte[4096];
        for (long currentOffset = offset; currentOffset < offset + length; currentOffset += (long)bytesToRead) {
            bytesToRead = (int)Math.min(length - (currentOffset - offset), (long)bytes.length);
            input.copyTo(currentOffset, bytes, 0, bytesToRead);
            this.write(bytes, 0, bytesToRead);
        }
    }
}

