/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.StringUtils;

public enum AggregationFunctionType {
    COUNT("count"),
    MIN("min", SqlTypeName.DOUBLE, SqlTypeName.DOUBLE),
    MAX("max", SqlTypeName.DOUBLE, SqlTypeName.DOUBLE),
    SUM("sum", SqlTypeName.DOUBLE, SqlTypeName.DOUBLE),
    SUM0("$sum0", SqlTypeName.DOUBLE, SqlTypeName.DOUBLE),
    SUMPRECISION("sumPrecision", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DECIMAL), (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER),
    AVG("avg", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    MODE("mode", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    FIRSTWITHTIME("firstWithTime", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER}), SqlTypeName.OTHER),
    LASTWITHTIME("lastWithTime", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER}), SqlTypeName.OTHER),
    MINMAXRANGE("minMaxRange", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    DISTINCTCOUNT("distinctCount", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER, SqlTypeName.INTEGER),
    DISTINCTSUM("distinctSum", ReturnTypes.AGG_SUM, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    DISTINCTAVG("distinctAvg", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlTypeName.OTHER),
    DISTINCTCOUNTBITMAP("distinctCountBitmap", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER, SqlTypeName.INTEGER),
    SEGMENTPARTITIONEDDISTINCTCOUNT("segmentPartitionedDistinctCount", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER),
    DISTINCTCOUNTHLL("distinctCountHLL", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTRAWHLL("distinctCountRawHLL", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTSMARTHLL("distinctCountSmartHLL", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER), i -> i == 1), SqlTypeName.OTHER),
    FASTHLL("fastHLL"),
    DISTINCTCOUNTHLLPLUS("distinctCountHLLPlus", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTRAWHLLPLUS("distinctCountRawHLLPlus", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTULL("distinctCountULL", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTRAWULL("distinctCountRawULL", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTTHETASKETCH("distinctCountThetaSketch", ReturnTypes.BIGINT, OperandTypes.ONE_OR_MORE, SqlTypeName.OTHER),
    DISTINCTCOUNTRAWTHETASKETCH("distinctCountRawThetaSketch", ReturnTypes.VARCHAR, OperandTypes.ONE_OR_MORE, SqlTypeName.OTHER),
    DISTINCTCOUNTTUPLESKETCH("distinctCountTupleSketch", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.BINARY, SqlTypeName.OTHER),
    DISTINCTCOUNTRAWINTEGERSUMTUPLESKETCH("distinctCountRawIntegerSumTupleSketch", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.BINARY, SqlTypeName.OTHER),
    SUMVALUESINTEGERSUMTUPLESKETCH("sumValuesIntegerSumTupleSketch", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.BINARY, SqlTypeName.OTHER),
    AVGVALUEINTEGERSUMTUPLESKETCH("avgValueIntegerSumTupleSketch", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.BINARY, SqlTypeName.OTHER),
    DISTINCTCOUNTCPCSKETCH("distinctCountCPCSketch", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.ANY), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTRAWCPCSKETCH("distinctCountRawCPCSketch", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.ANY), i -> i == 1), SqlTypeName.OTHER),
    PERCENTILE("percentile", ReturnTypes.ARG0, (SqlOperandTypeChecker)OperandTypes.ANY_NUMERIC, SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    PERCENTILEEST("percentileEst", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ANY_NUMERIC, SqlTypeName.OTHER),
    PERCENTILERAWEST("percentileRawEst", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.ANY_NUMERIC, SqlTypeName.OTHER),
    PERCENTILETDIGEST("percentileTDigest", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER),
    PERCENTILERAWTDIGEST("percentileRawTDigest", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER),
    PERCENTILESMARTTDIGEST("percentileSmartTDigest", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER), i -> i == 2), SqlTypeName.OTHER),
    PERCENTILEKLL("percentileKLL", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER),
    PERCENTILERAWKLL("percentileRawKLL", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER),
    IDSET("idSet", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER), i -> i == 1), SqlTypeName.OTHER),
    HISTOGRAM("histogram", new ArrayReturnTypeInference(SqlTypeName.DOUBLE), OperandTypes.VARIADIC, SqlTypeName.OTHER),
    COVARPOP("covarPop", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    COVARSAMP("covarSamp", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    VARPOP("varPop", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    VARSAMP("varSamp", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    STDDEVPOP("stdDevPop", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    STDDEVSAMP("stdDevSamp", SqlTypeName.OTHER, SqlTypeName.DOUBLE),
    SKEWNESS("skewness", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER),
    KURTOSIS("kurtosis", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER),
    FOURTHMOMENT("fourthMoment", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER),
    FREQUENTSTRINGSSKETCH("frequentStringsSketch", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER),
    FREQUENTLONGSSKETCH("frequentLongsSketch", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.ANY, SqlTypeName.OTHER),
    STUNION("STUnion", ReturnTypes.VARBINARY, (SqlOperandTypeChecker)OperandTypes.BINARY, SqlTypeName.OTHER),
    BOOLAND("boolAnd", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.BOOLEAN, SqlTypeName.INTEGER),
    BOOLOR("boolOr", ReturnTypes.BOOLEAN, (SqlOperandTypeChecker)OperandTypes.BOOLEAN, SqlTypeName.INTEGER),
    EXPRMIN("exprMin", ReturnTypes.ARG0, OperandTypes.VARIADIC, SqlTypeName.OTHER),
    EXPRMAX("exprMax", ReturnTypes.ARG0, OperandTypes.VARIADIC, SqlTypeName.OTHER),
    PINOTPARENTAGGEXPRMIN("pinotparentagg" + EXPRMIN.getName(), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER), OperandTypes.VARIADIC, SqlTypeName.OTHER),
    PINOTPARENTAGGEXPRMAX("pinotparentagg" + EXPRMAX.getName(), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.OTHER), OperandTypes.VARIADIC, SqlTypeName.OTHER),
    PINOTCHILDAGGEXPRMIN("pinotchildagg" + EXPRMIN.getName(), ReturnTypes.ARG1, OperandTypes.VARIADIC, SqlTypeName.OTHER, SqlTypeName.BIGINT),
    PINOTCHILDAGGEXPRMAX("pinotchildagg" + EXPRMAX.getName(), ReturnTypes.ARG1, OperandTypes.VARIADIC, SqlTypeName.OTHER, SqlTypeName.BIGINT),
    ARRAYAGG("arrayAgg", ReturnTypes.TO_ARRAY, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.BOOLEAN), i -> i == 2), SqlTypeName.OTHER),
    LISTAGG("listAgg", SqlTypeName.OTHER, SqlTypeName.VARCHAR),
    SUMARRAYLONG("sumArrayLong", new ArrayReturnTypeInference(SqlTypeName.BIGINT), (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER),
    SUMARRAYDOUBLE("sumArrayDouble", new ArrayReturnTypeInference(SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER),
    FUNNELMAXSTEP("funnelMaxStep", ReturnTypes.INTEGER, OperandTypes.VARIADIC, SqlTypeName.OTHER),
    FUNNELCOMPLETECOUNT("funnelCompleteCount", ReturnTypes.INTEGER, OperandTypes.VARIADIC, SqlTypeName.OTHER),
    FUNNELMATCHSTEP("funnelMatchStep", new ArrayReturnTypeInference(SqlTypeName.INTEGER), OperandTypes.VARIADIC, SqlTypeName.OTHER),
    FUNNELCOUNT("funnelCount", new ArrayReturnTypeInference(SqlTypeName.BIGINT), OperandTypes.VARIADIC, SqlTypeName.OTHER),
    COUNTMV("countMV", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ARRAY),
    MINMV("minMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY),
    MAXMV("maxMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY),
    SUMMV("sumMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY),
    AVGMV("avgMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER),
    MINMAXRANGEMV("minMaxRangeMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER),
    DISTINCTCOUNTMV("distinctCountMV", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER, SqlTypeName.INTEGER),
    DISTINCTSUMMV("distinctSumMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER),
    DISTINCTAVGMV("distinctAvgMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER),
    DISTINCTCOUNTBITMAPMV("distinctCountBitmapMV", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.ARRAY, SqlTypeName.OTHER, SqlTypeName.INTEGER),
    DISTINCTCOUNTHLLMV("distinctCountHLLMV", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTRAWHLLMV("distinctCountRawHLLMV", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTHLLPLUSMV("distinctCountHLLPlusMV", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    DISTINCTCOUNTRAWHLLPLUSMV("distinctCountRawHLLPlusMV", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER), i -> i == 1), SqlTypeName.OTHER),
    PERCENTILEMV("percentileMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC)), SqlTypeName.OTHER),
    PERCENTILEESTMV("percentileEstMV", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC)), SqlTypeName.OTHER),
    PERCENTILERAWESTMV("percentileRawEstMV", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC)), SqlTypeName.OTHER),
    PERCENTILETDIGESTMV("percentileTDigestMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER),
    PERCENTILERAWTDIGESTMV("percentileRawTDigestMV", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER),
    PERCENTILEKLLMV("percentileKLLMV", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER),
    PERCENTILERAWKLLMV("percentileRawKLLMV", ReturnTypes.VARCHAR, (SqlOperandTypeChecker)OperandTypes.family(List.of(SqlTypeFamily.ARRAY, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), i -> i == 2), SqlTypeName.OTHER);

    private static final Set<String> NAMES;
    private final String _name;
    private final SqlReturnTypeInference _returnTypeInference;
    private final SqlOperandTypeChecker _operandTypeChecker;
    private final SqlReturnTypeInference _intermediateReturnTypeInference;
    private final SqlReturnTypeInference _finalReturnTypeInference;

    private AggregationFunctionType(String name) {
        this(name, null, null, (SqlReturnTypeInference)null, null);
    }

    private AggregationFunctionType(String name, SqlTypeName intermediateReturnType) {
        this(name, null, null, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)intermediateReturnType), null);
    }

    private AggregationFunctionType(String name, SqlTypeName intermediateReturnType, SqlTypeName finalReturnType) {
        this(name, null, null, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)intermediateReturnType), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)finalReturnType));
    }

    private AggregationFunctionType(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        this(name, returnTypeInference, operandTypeChecker, (SqlReturnTypeInference)null, null);
    }

    private AggregationFunctionType(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlTypeName intermediateReturnType) {
        this(name, returnTypeInference, operandTypeChecker, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)intermediateReturnType), null);
    }

    private AggregationFunctionType(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlTypeName intermediateReturnType, SqlTypeName finalReturnType) {
        this(name, returnTypeInference, operandTypeChecker, (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)intermediateReturnType), (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)finalReturnType));
    }

    private AggregationFunctionType(@Nullable String name, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlReturnTypeInference intermediateReturnTypeInference, SqlReturnTypeInference finalReturnTypeInference) {
        this._name = name;
        this._returnTypeInference = returnTypeInference;
        this._operandTypeChecker = operandTypeChecker;
        this._intermediateReturnTypeInference = intermediateReturnTypeInference;
        this._finalReturnTypeInference = finalReturnTypeInference;
    }

    public String getName() {
        return this._name;
    }

    @Nullable
    public SqlReturnTypeInference getReturnTypeInference() {
        return this._returnTypeInference;
    }

    @Nullable
    public SqlOperandTypeChecker getOperandTypeChecker() {
        return this._operandTypeChecker;
    }

    @Nullable
    public SqlReturnTypeInference getIntermediateReturnTypeInference() {
        return this._intermediateReturnTypeInference;
    }

    @Nullable
    public SqlReturnTypeInference getFinalReturnTypeInference() {
        return this._finalReturnTypeInference;
    }

    public static boolean isAggregationFunction(String functionName) {
        if (NAMES.contains(functionName)) {
            return true;
        }
        if (functionName.regionMatches(true, 0, "percentile", 0, 10)) {
            try {
                AggregationFunctionType.getAggregationFunctionType(functionName);
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }
        String upperCaseFunctionName = AggregationFunctionType.getNormalizedAggregationFunctionName(functionName);
        return NAMES.contains(upperCaseFunctionName);
    }

    public static String getNormalizedAggregationFunctionName(String functionName) {
        return StringUtils.remove((String)StringUtils.remove((String)functionName, (char)'_').toUpperCase(), (String)"$");
    }

    public static AggregationFunctionType getAggregationFunctionType(String functionName) {
        String normalizedFunctionName = AggregationFunctionType.getNormalizedAggregationFunctionName(functionName);
        if (normalizedFunctionName.regionMatches(false, 0, "PERCENTILE", 0, 10)) {
            String remainingFunctionName = normalizedFunctionName.substring(10).toUpperCase();
            if (remainingFunctionName.isEmpty() || remainingFunctionName.matches("\\d+")) {
                return PERCENTILE;
            }
            if (remainingFunctionName.equals("EST") || remainingFunctionName.matches("EST\\d+")) {
                return PERCENTILEEST;
            }
            if (remainingFunctionName.equals("RAWEST") || remainingFunctionName.matches("RAWEST\\d+")) {
                return PERCENTILERAWEST;
            }
            if (remainingFunctionName.equals("TDIGEST") || remainingFunctionName.matches("TDIGEST\\d+")) {
                return PERCENTILETDIGEST;
            }
            if (remainingFunctionName.equals("RAWTDIGEST") || remainingFunctionName.matches("RAWTDIGEST\\d+")) {
                return PERCENTILERAWTDIGEST;
            }
            if (remainingFunctionName.equals("KLL") || remainingFunctionName.matches("KLL\\d+")) {
                return PERCENTILEKLL;
            }
            if (remainingFunctionName.equals("RAWKLL") || remainingFunctionName.matches("RAWKLL\\d+")) {
                return PERCENTILERAWKLL;
            }
            if (remainingFunctionName.equals("MV") || remainingFunctionName.matches("\\d+MV")) {
                return PERCENTILEMV;
            }
            if (remainingFunctionName.equals("ESTMV") || remainingFunctionName.matches("EST\\d+MV")) {
                return PERCENTILEESTMV;
            }
            if (remainingFunctionName.equals("RAWESTMV") || remainingFunctionName.matches("RAWEST\\d+MV")) {
                return PERCENTILERAWESTMV;
            }
            if (remainingFunctionName.equals("TDIGESTMV") || remainingFunctionName.matches("TDIGEST\\d+MV")) {
                return PERCENTILETDIGESTMV;
            }
            if (remainingFunctionName.equals("RAWTDIGESTMV") || remainingFunctionName.matches("RAWTDIGEST\\d+MV")) {
                return PERCENTILERAWTDIGESTMV;
            }
            if (remainingFunctionName.equals("KLLMV") || remainingFunctionName.matches("KLL\\d+MV")) {
                return PERCENTILEKLLMV;
            }
            if (remainingFunctionName.equals("RAWKLLMV") || remainingFunctionName.matches("RAWKLL\\d+MV")) {
                return PERCENTILEKLLMV;
            }
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
        try {
            return AggregationFunctionType.valueOf(normalizedFunctionName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
    }

    static {
        NAMES = Arrays.stream(AggregationFunctionType.values()).flatMap(func -> Stream.of(func.name(), func.getName(), func.getName().toLowerCase())).collect(Collectors.toSet());
    }

    private static class ArrayReturnTypeInference
    implements SqlReturnTypeInference {
        final SqlTypeName _sqlTypeName;

        ArrayReturnTypeInference(SqlTypeName sqlTypeName) {
            this._sqlTypeName = sqlTypeName;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType elementType = typeFactory.createSqlType(this._sqlTypeName);
            return typeFactory.createArrayType(elementType, -1L);
        }
    }
}

