/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.creator.name;

import java.util.regex.Pattern;

public class SegmentNameUtils {
    public static final char SEGMENT_NAME_SEPARATOR = '|';
    private static final Pattern INVALID_SEGMENT_NAME_REGEX = Pattern.compile(".*[\\\\/:\\*?\"<>|].*");

    private SegmentNameUtils() {
    }

    public static void validatePartialOrFullSegmentName(String partialOrFullSegmentName) {
        if (INVALID_SEGMENT_NAME_REGEX.matcher(partialOrFullSegmentName).matches()) {
            throw new IllegalArgumentException("Invalid partial or full segment name: " + partialOrFullSegmentName);
        }
    }
}

