/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.utils.JsonUtils;

public class FieldIndexConfigs {
    public static final FieldIndexConfigs EMPTY = new FieldIndexConfigs(new HashMap<IndexType, IndexConfig>());
    private final Map<IndexType, IndexConfig> _configMap;

    private FieldIndexConfigs(Map<IndexType, IndexConfig> configMap) {
        this._configMap = Collections.unmodifiableMap(configMap);
    }

    public <C extends IndexConfig, I extends IndexType<C, ?, ?>> C getConfig(I indexType) {
        IndexConfig config = this._configMap.get(indexType);
        if (config == null) {
            return indexType.getDefaultConfig();
        }
        return (C)config;
    }

    public Map<String, JsonNode> unwrapIndexes() {
        Function<Map.Entry, JsonNode> serializer = entry -> ((IndexConfig)entry.getValue()).toJsonNode();
        return this._configMap.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(entry -> ((IndexType)entry.getKey()).getId(), serializer));
    }

    public String toString() {
        try {
            return JsonUtils.objectToString(this.unwrapIndexes());
        }
        catch (JsonProcessingException e) {
            return "Unserializable value due to " + e.getMessage();
        }
    }

    public static class UnrecognizedIndexException
    extends RuntimeException {
        private final String _indexId;

        public UnrecognizedIndexException(String indexId) {
            super("There is no index type whose identified as " + indexId);
            this._indexId = indexId;
        }

        public String getIndexId() {
            return this._indexId;
        }
    }

    public static class Builder {
        private final Map<IndexType, IndexConfig> _configMap;

        public Builder() {
            this._configMap = new HashMap<IndexType, IndexConfig>();
        }

        public Builder(FieldIndexConfigs other) {
            this._configMap = new HashMap<IndexType, IndexConfig>(other._configMap);
        }

        public <C extends IndexConfig, I extends IndexType<C, ?, ?>> Builder add(I indexType, C config) {
            this._configMap.put(indexType, config);
            return this;
        }

        public Builder addUnsafe(IndexType<?, ?, ?> indexType, IndexConfig config) {
            this._configMap.put(indexType, config);
            return this;
        }

        public Builder undeclare(IndexType<?, ?, ?> indexType) {
            this._configMap.remove(indexType);
            return this;
        }

        public FieldIndexConfigs build() {
            return new FieldIndexConfigs(this._configMap);
        }
    }
}

