/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.utils.CsvParser;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.config.table.IndexConfig;

public class TextIndexConfig
extends IndexConfig {
    private static final int LUCENE_INDEX_DEFAULT_MAX_BUFFER_SIZE_MB = 500;
    private static final boolean LUCENE_INDEX_DEFAULT_USE_COMPOUND_FILE = true;
    private static final boolean LUCENE_INDEX_ENABLE_PREFIX_SUFFIX_MATCH_IN_PHRASE_SEARCH = false;
    private static final boolean LUCENE_INDEX_REUSE_MUTABLE_INDEX = false;
    private static final int LUCENE_INDEX_NRT_CACHING_DIRECTORY_MAX_BUFFER_SIZE_MB = 0;
    private static final boolean LUCENE_INDEX_DEFAULT_USE_AND_FOR_MULTI_TERM_QUERIES = false;
    public static final TextIndexConfig DISABLED = new TextIndexConfig(true, null, null, false, false, Collections.emptyList(), Collections.emptyList(), false, 500, null, null, null, null, false, false, 0);
    private final FSTType _fstType;
    @Nullable
    private final Object _rawValueForTextIndex;
    private final boolean _enableQueryCache;
    private final boolean _useANDForMultiTermQueries;
    private final List<String> _stopWordsInclude;
    private final List<String> _stopWordsExclude;
    private final boolean _luceneUseCompoundFile;
    private final int _luceneMaxBufferSizeMB;
    private final String _luceneAnalyzerClass;
    private final List<String> _luceneAnalyzerClassArgs;
    private final List<String> _luceneAnalyzerClassArgTypes;
    private final String _luceneQueryParserClass;
    private final boolean _enablePrefixSuffixMatchingInPhraseQueries;
    private final boolean _reuseMutableIndex;
    private final int _luceneNRTCachingDirectoryMaxBufferSizeMB;

    @JsonCreator
    public TextIndexConfig(@JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="fst") FSTType fstType, @JsonProperty(value="rawValue") @Nullable Object rawValueForTextIndex, @JsonProperty(value="queryCache") boolean enableQueryCache, @JsonProperty(value="useANDForMultiTermQueries") boolean useANDForMultiTermQueries, @JsonProperty(value="stopWordsInclude") List<String> stopWordsInclude, @JsonProperty(value="stopWordsExclude") List<String> stopWordsExclude, @JsonProperty(value="luceneUseCompoundFile") Boolean luceneUseCompoundFile, @JsonProperty(value="luceneMaxBufferSizeMB") Integer luceneMaxBufferSizeMB, @JsonProperty(value="luceneAnalyzerClass") String luceneAnalyzerClass, @JsonProperty(value="luceneAnalyzerClassArgs") String luceneAnalyzerClassArgs, @JsonProperty(value="luceneAnalyzerClassArgTypes") String luceneAnalyzerClassArgTypes, @JsonProperty(value="luceneQueryParserClass") String luceneQueryParserClass, @JsonProperty(value="enablePrefixSuffixMatchingInPhraseQueries") Boolean enablePrefixSuffixMatchingInPhraseQueries, @JsonProperty(value="reuseMutableIndex") Boolean reuseMutableIndex, @JsonProperty(value="luceneNRTCachingDirectoryMaxBufferSizeMB") Integer luceneNRTCachingDirectoryMaxBufferSizeMB) {
        super(disabled);
        this._fstType = fstType;
        this._rawValueForTextIndex = rawValueForTextIndex;
        this._enableQueryCache = enableQueryCache;
        this._useANDForMultiTermQueries = useANDForMultiTermQueries;
        this._stopWordsInclude = stopWordsInclude;
        this._stopWordsExclude = stopWordsExclude;
        this._luceneUseCompoundFile = luceneUseCompoundFile == null ? true : luceneUseCompoundFile;
        this._luceneMaxBufferSizeMB = luceneMaxBufferSizeMB == null ? 500 : luceneMaxBufferSizeMB;
        this._luceneAnalyzerClass = luceneAnalyzerClass == null || luceneAnalyzerClass.isEmpty() ? "org.apache.lucene.analysis.standard.StandardAnalyzer" : luceneAnalyzerClass;
        this._luceneAnalyzerClassArgs = CsvParser.parse(luceneAnalyzerClassArgs, true, false);
        this._luceneAnalyzerClassArgTypes = CsvParser.parse(luceneAnalyzerClassArgTypes, false, true);
        this._luceneQueryParserClass = luceneQueryParserClass == null ? "org.apache.lucene.queryparser.classic.QueryParser" : luceneQueryParserClass;
        this._enablePrefixSuffixMatchingInPhraseQueries = enablePrefixSuffixMatchingInPhraseQueries == null ? false : enablePrefixSuffixMatchingInPhraseQueries;
        this._reuseMutableIndex = reuseMutableIndex == null ? false : reuseMutableIndex;
        this._luceneNRTCachingDirectoryMaxBufferSizeMB = luceneNRTCachingDirectoryMaxBufferSizeMB == null ? 0 : luceneNRTCachingDirectoryMaxBufferSizeMB;
    }

    public FSTType getFstType() {
        return this._fstType;
    }

    @Nullable
    public Object getRawValueForTextIndex() {
        return this._rawValueForTextIndex;
    }

    public boolean isEnableQueryCache() {
        return this._enableQueryCache;
    }

    public boolean isUseANDForMultiTermQueries() {
        return this._useANDForMultiTermQueries;
    }

    public List<String> getStopWordsInclude() {
        return this._stopWordsInclude;
    }

    public List<String> getStopWordsExclude() {
        return this._stopWordsExclude;
    }

    public boolean isLuceneUseCompoundFile() {
        return this._luceneUseCompoundFile;
    }

    public int getLuceneMaxBufferSizeMB() {
        return this._luceneMaxBufferSizeMB;
    }

    public String getLuceneAnalyzerClass() {
        return this._luceneAnalyzerClass;
    }

    public List<String> getLuceneAnalyzerClassArgs() {
        return this._luceneAnalyzerClassArgs;
    }

    public List<String> getLuceneAnalyzerClassArgTypes() {
        return this._luceneAnalyzerClassArgTypes;
    }

    public String getLuceneQueryParserClass() {
        return this._luceneQueryParserClass;
    }

    public boolean isEnablePrefixSuffixMatchingInPhraseQueries() {
        return this._enablePrefixSuffixMatchingInPhraseQueries;
    }

    public boolean isReuseMutableIndex() {
        return this._reuseMutableIndex;
    }

    public int getLuceneNRTCachingDirectoryMaxBufferSizeMB() {
        return this._luceneNRTCachingDirectoryMaxBufferSizeMB;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextIndexConfig that = (TextIndexConfig)((Object)o);
        return this._enableQueryCache == that._enableQueryCache && this._useANDForMultiTermQueries == that._useANDForMultiTermQueries && this._luceneUseCompoundFile == that._luceneUseCompoundFile && this._luceneMaxBufferSizeMB == that._luceneMaxBufferSizeMB && this._enablePrefixSuffixMatchingInPhraseQueries == that._enablePrefixSuffixMatchingInPhraseQueries && this._reuseMutableIndex == that._reuseMutableIndex && this._luceneNRTCachingDirectoryMaxBufferSizeMB == that._luceneNRTCachingDirectoryMaxBufferSizeMB && this._fstType == that._fstType && Objects.equals(this._rawValueForTextIndex, that._rawValueForTextIndex) && Objects.equals(this._stopWordsInclude, that._stopWordsInclude) && Objects.equals(this._stopWordsExclude, that._stopWordsExclude) && Objects.equals(this._luceneAnalyzerClass, that._luceneAnalyzerClass) && Objects.equals(this._luceneAnalyzerClassArgs, that._luceneAnalyzerClassArgs) && Objects.equals(this._luceneAnalyzerClassArgTypes, that._luceneAnalyzerClassArgTypes) && Objects.equals(this._luceneQueryParserClass, that._luceneQueryParserClass);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this._fstType, this._rawValueForTextIndex, this._enableQueryCache, this._useANDForMultiTermQueries, this._stopWordsInclude, this._stopWordsExclude, this._luceneUseCompoundFile, this._luceneMaxBufferSizeMB, this._luceneAnalyzerClass, this._luceneAnalyzerClassArgs, this._luceneAnalyzerClassArgTypes, this._luceneQueryParserClass, this._enablePrefixSuffixMatchingInPhraseQueries, this._reuseMutableIndex, this._luceneNRTCachingDirectoryMaxBufferSizeMB);
    }

    public static abstract class AbstractBuilder {
        @Nullable
        protected FSTType _fstType;
        @Nullable
        protected Object _rawValueForTextIndex;
        protected boolean _enableQueryCache = false;
        protected boolean _useANDForMultiTermQueries = false;
        protected List<String> _stopWordsInclude = new ArrayList<String>();
        protected List<String> _stopWordsExclude = new ArrayList<String>();
        protected boolean _luceneUseCompoundFile = true;
        protected int _luceneMaxBufferSizeMB = 500;
        protected String _luceneAnalyzerClass = "org.apache.lucene.analysis.standard.StandardAnalyzer";
        protected List<String> _luceneAnalyzerClassArgs = new ArrayList<String>();
        protected List<String> _luceneAnalyzerClassArgTypes = new ArrayList<String>();
        protected String _luceneQueryParserClass = "org.apache.lucene.queryparser.classic.QueryParser";
        protected boolean _enablePrefixSuffixMatchingInPhraseQueries = false;
        protected boolean _reuseMutableIndex = false;
        protected int _luceneNRTCachingDirectoryMaxBufferSizeMB = 0;

        public AbstractBuilder(@Nullable FSTType fstType) {
            this._fstType = fstType;
        }

        public AbstractBuilder(TextIndexConfig other) {
            this._fstType = other._fstType;
            this._enableQueryCache = other._enableQueryCache;
            this._useANDForMultiTermQueries = other._useANDForMultiTermQueries;
            this._stopWordsInclude = other._stopWordsInclude == null ? new ArrayList<String>() : new ArrayList<String>(other._stopWordsInclude);
            this._stopWordsExclude = other._stopWordsExclude == null ? new ArrayList<String>() : new ArrayList<String>(other._stopWordsExclude);
            this._luceneUseCompoundFile = other._luceneUseCompoundFile;
            this._luceneMaxBufferSizeMB = other._luceneMaxBufferSizeMB;
            this._luceneAnalyzerClass = other._luceneAnalyzerClass;
            this._luceneAnalyzerClassArgs = other._luceneAnalyzerClassArgs;
            this._luceneAnalyzerClassArgTypes = other._luceneAnalyzerClassArgTypes;
            this._luceneQueryParserClass = other._luceneQueryParserClass;
            this._enablePrefixSuffixMatchingInPhraseQueries = other._enablePrefixSuffixMatchingInPhraseQueries;
            this._reuseMutableIndex = other._reuseMutableIndex;
            this._luceneNRTCachingDirectoryMaxBufferSizeMB = other._luceneNRTCachingDirectoryMaxBufferSizeMB;
        }

        public TextIndexConfig build() {
            return new TextIndexConfig(false, this._fstType, this._rawValueForTextIndex, this._enableQueryCache, this._useANDForMultiTermQueries, this._stopWordsInclude, this._stopWordsExclude, this._luceneUseCompoundFile, this._luceneMaxBufferSizeMB, this._luceneAnalyzerClass, CsvParser.serialize(this._luceneAnalyzerClassArgs, true, false), CsvParser.serialize(this._luceneAnalyzerClassArgTypes, true, false), this._luceneQueryParserClass, this._enablePrefixSuffixMatchingInPhraseQueries, this._reuseMutableIndex, this._luceneNRTCachingDirectoryMaxBufferSizeMB);
        }

        public abstract AbstractBuilder withProperties(@Nullable Map<String, String> var1);

        public AbstractBuilder withRawValueForTextIndex(@Nullable Object rawValueForTextIndex) {
            this._rawValueForTextIndex = rawValueForTextIndex;
            return this;
        }

        public AbstractBuilder withUseANDForMultiTermQueries(boolean useANDForMultiTermQueries) {
            this._useANDForMultiTermQueries = useANDForMultiTermQueries;
            return this;
        }

        public AbstractBuilder withStopWordsInclude(List<String> stopWordsInclude) {
            this._stopWordsInclude = stopWordsInclude;
            return this;
        }

        public AbstractBuilder withStopWordsExclude(List<String> stopWordsExclude) {
            this._stopWordsExclude = stopWordsExclude;
            return this;
        }

        public AbstractBuilder withLuceneUseCompoundFile(boolean useCompoundFile) {
            this._luceneUseCompoundFile = useCompoundFile;
            return this;
        }

        public AbstractBuilder withLuceneMaxBufferSizeMB(int maxBufferSizeMB) {
            this._luceneMaxBufferSizeMB = maxBufferSizeMB;
            return this;
        }

        public AbstractBuilder withLuceneAnalyzerClass(String luceneAnalyzerClass) {
            this._luceneAnalyzerClass = luceneAnalyzerClass;
            return this;
        }

        public AbstractBuilder withLuceneAnalyzerClassArgs(String luceneAnalyzerClassArgs) {
            this._luceneAnalyzerClassArgs = CsvParser.parse(luceneAnalyzerClassArgs, true, false);
            return this;
        }

        public AbstractBuilder withLuceneAnalyzerClassArgs(List<String> luceneAnalyzerClassArgs) {
            this._luceneAnalyzerClassArgs = luceneAnalyzerClassArgs;
            return this;
        }

        public AbstractBuilder withLuceneAnalyzerClassArgTypes(String luceneAnalyzerClassArgTypes) {
            this._luceneAnalyzerClassArgTypes = CsvParser.parse(luceneAnalyzerClassArgTypes, false, true);
            return this;
        }

        public AbstractBuilder withLuceneAnalyzerClassArgTypes(List<String> luceneAnalyzerClassArgTypes) {
            this._luceneAnalyzerClassArgTypes = luceneAnalyzerClassArgTypes;
            return this;
        }

        public AbstractBuilder withLuceneQueryParserClass(String luceneQueryParserClass) {
            this._luceneQueryParserClass = luceneQueryParserClass;
            return this;
        }

        public AbstractBuilder withEnablePrefixSuffixMatchingInPhraseQueries(boolean enablePrefixSuffixMatchingInPhraseQueries) {
            this._enablePrefixSuffixMatchingInPhraseQueries = enablePrefixSuffixMatchingInPhraseQueries;
            return this;
        }

        public AbstractBuilder withReuseMutableIndex(boolean reuseMutableIndex) {
            this._reuseMutableIndex = reuseMutableIndex;
            return this;
        }

        public AbstractBuilder withLuceneNRTCachingDirectoryMaxBufferSizeMB(int luceneNRTCachingDirectoryMaxBufferSizeMB) {
            this._luceneNRTCachingDirectoryMaxBufferSizeMB = luceneNRTCachingDirectoryMaxBufferSizeMB;
            return this;
        }
    }
}

