/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.column;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexType;

public interface ColumnIndexContainer
extends Closeable {
    @Nullable
    public <I extends IndexReader, T extends IndexType<?, I, ?>> I getIndex(T var1);

    public static class FromMap
    implements ColumnIndexContainer {
        private final Map<IndexType, ? extends IndexReader> _readersByIndex;

        public FromMap(Map<IndexType, ? extends IndexReader> readersByIndex) {
            this._readersByIndex = readersByIndex;
        }

        @Override
        @Nullable
        public <I extends IndexReader, T extends IndexType<?, I, ?>> I getIndex(T indexType) {
            return (I)this._readersByIndex.get(indexType);
        }

        @Override
        public void close() throws IOException {
        }

        public static class Builder {
            private final Map<IndexType, IndexReader> _readersByIndex = new HashMap<IndexType, IndexReader>();

            public Builder withAll(Map<IndexType, ? extends IndexReader> safeMap) {
                this._readersByIndex.putAll(safeMap);
                return this;
            }

            public <R extends IndexReader> Builder with(IndexType<?, ? super R, ?> type, R reader) {
                this._readersByIndex.put(type, reader);
                return this;
            }

            public FromMap build() {
                return new FromMap(this._readersByIndex);
            }
        }
    }

    public static class Empty
    implements ColumnIndexContainer {
        public static final Empty INSTANCE = new Empty();

        @Override
        @Nullable
        public <I extends IndexReader, T extends IndexType<?, I, ?>> I getIndex(T indexType) {
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

