/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.partition;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.pinot.segment.spi.partition.PartitionFunction;

public class ByteArrayPartitionFunction
implements PartitionFunction {
    private static final String NAME = "ByteArray";
    private final int _numPartitions;

    public ByteArrayPartitionFunction(int numPartitions) {
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (String)"Number of partitions must be > 0, specified", (int)numPartitions);
        this._numPartitions = numPartitions;
    }

    @Override
    public int getPartition(String value) {
        return ByteArrayPartitionFunction.abs(Arrays.hashCode(value.getBytes(StandardCharsets.UTF_8))) % this._numPartitions;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumPartitions() {
        return this._numPartitions;
    }

    public String toString() {
        return NAME;
    }

    private static int abs(int n) {
        return n == Integer.MIN_VALUE ? 0 : Math.abs(n);
    }
}

