/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class CsvParser {
    private CsvParser() {
    }

    public static List<String> parse(@Nullable String input, boolean escapeComma, boolean trim) {
        if (null == input || input.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<String> tokenStream = escapeComma ? Arrays.stream(input.split("(?<!\\\\),", -1)).map(s -> s.replace("\\,", ",")) : Arrays.stream(input.split(","));
        if (trim) {
            tokenStream = tokenStream.map(String::trim);
        }
        return tokenStream.collect(Collectors.toList());
    }

    public static String serialize(List<String> input, boolean escapeComma, boolean trim) {
        Stream<Object> tokenStream = input.stream();
        if (escapeComma) {
            tokenStream = tokenStream.map(s -> s.replaceAll(",", Matcher.quoteReplacement("\\,")));
        }
        if (trim) {
            tokenStream = tokenStream.map(String::trim);
        }
        return tokenStream.collect(Collectors.joining(","));
    }
}

