/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Map;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;

public class SegmentMetadataUtils {
    private SegmentMetadataUtils() {
    }

    public static PropertiesConfiguration getPropertiesConfiguration(File indexDir) throws ConfigurationException {
        File metadataFile = SegmentDirectoryPaths.findMetadataFile(indexDir);
        Preconditions.checkNotNull((Object)metadataFile, (String)"Cannot find segment metadata file under directory: %s", (Object)indexDir);
        return CommonsConfigurationUtils.fromFile((File)metadataFile);
    }

    public static PropertiesConfiguration getPropertiesConfiguration(SegmentMetadata segmentMetadata) throws ConfigurationException {
        File indexDir = segmentMetadata.getIndexDir();
        Preconditions.checkState((indexDir != null ? 1 : 0) != 0, (String)"Cannot get PropertiesConfiguration from in-memory segment: %s", (Object)segmentMetadata.getName());
        return SegmentMetadataUtils.getPropertiesConfiguration(indexDir);
    }

    public static void savePropertiesConfiguration(PropertiesConfiguration propertiesConfiguration, File indexDir) {
        File metadataFile = SegmentDirectoryPaths.findMetadataFile(indexDir);
        Preconditions.checkState((metadataFile != null ? 1 : 0) != 0, (String)"Cannot find segment metadata file under directory: %s", (Object)indexDir);
        CommonsConfigurationUtils.saveToFile((PropertiesConfiguration)propertiesConfiguration, (File)metadataFile);
    }

    public static SegmentMetadata updateMetadataProperties(SegmentDirectory segmentDirectory, Map<String, String> metadataProperties) throws Exception {
        SegmentMetadataImpl segmentMetadata = segmentDirectory.getSegmentMetadata();
        PropertiesConfiguration propertiesConfiguration = SegmentMetadataUtils.getPropertiesConfiguration(segmentMetadata);
        for (Map.Entry<String, String> entry : metadataProperties.entrySet()) {
            propertiesConfiguration.setProperty(entry.getKey(), (Object)entry.getValue());
        }
        SegmentMetadataUtils.savePropertiesConfiguration(propertiesConfiguration, segmentMetadata.getIndexDir());
        segmentDirectory.reloadMetadata();
        return segmentDirectory.getSegmentMetadata();
    }
}

