/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.instance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.instance.InstanceType;

public class Instance
extends BaseJsonConfig {
    public static final int NOT_SET_GRPC_PORT_VALUE = -1;
    public static final int NOT_SET_ADMIN_PORT_VALUE = -1;
    private final String _host;
    private final int _port;
    private final InstanceType _type;
    private final List<String> _tags;
    private final Map<String, Integer> _pools;
    private final int _grpcPort;
    private final int _adminPort;
    private final boolean _queriesDisabled;

    @JsonCreator
    public Instance(@JsonProperty(value="host", required=true) String host, @JsonProperty(value="port", required=true) int port, @JsonProperty(value="type", required=true) InstanceType type, @JsonProperty(value="tags") @Nullable List<String> tags, @JsonProperty(value="pools") @Nullable Map<String, Integer> pools, @JsonProperty(value="grpcPort") int grpcPort, @JsonProperty(value="adminPort") int adminPort, @JsonProperty(value="queriesDisabled") boolean queriesDisabled) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"'host' must be configured");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"'type' must be configured");
        this._host = host;
        this._port = port;
        this._type = type;
        this._tags = tags;
        this._pools = pools;
        this._grpcPort = grpcPort == 0 ? -1 : grpcPort;
        this._adminPort = adminPort == 0 ? -1 : adminPort;
        this._queriesDisabled = queriesDisabled;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public InstanceType getType() {
        return this._type;
    }

    @Nullable
    public List<String> getTags() {
        return this._tags;
    }

    @Nullable
    public Map<String, Integer> getPools() {
        return this._pools;
    }

    public int getGrpcPort() {
        return this._grpcPort;
    }

    public int getAdminPort() {
        return this._adminPort;
    }

    public boolean isQueriesDisabled() {
        return this._queriesDisabled;
    }
}

