/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class TierConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Name of the tier with format TIER<number>")
    private final String _name;
    @JsonPropertyDescription(value="The strategy for selecting segments")
    private final String _segmentSelectorType;
    @JsonPropertyDescription(value="For 'TIME' segment selector, the period after which to select segments for this tier")
    private final String _segmentAge;
    @JsonPropertyDescription(value="The type of storage")
    private final String _storageType;
    @JsonPropertyDescription(value="The tag with which to identify servers for this tier.")
    private final String _serverTag;
    @JsonPropertyDescription(value="The backend FS to use for this tier. Default is 'local'.")
    private final String _tierBackend;
    @JsonPropertyDescription(value="Properties for the tier backend")
    private final Map<String, String> _tierBackendProperties;

    public TierConfig(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="segmentSelectorType", required=true) String segmentSelectorType, @JsonProperty(value="segmentAge") @Nullable String segmentAge, @JsonProperty(value="storageType", required=true) String storageType, @JsonProperty(value="serverTag") @Nullable String serverTag, @JsonProperty(value="tierBackend") @Nullable String tierBackend, @JsonProperty(value="tierBackendProperties") @Nullable Map<String, String> tierBackendProperties) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Must provide non-null 'name' in tierConfig");
        Preconditions.checkArgument((segmentSelectorType != null ? 1 : 0) != 0, (Object)"Must provide non-null 'segmentSelectorType' in tierConfig");
        Preconditions.checkArgument((storageType != null ? 1 : 0) != 0, (Object)"Must provide non-null 'storageType' in tierConfig");
        this._name = name;
        this._segmentSelectorType = segmentSelectorType;
        this._segmentAge = segmentAge;
        this._storageType = storageType;
        this._serverTag = serverTag;
        this._tierBackend = tierBackend;
        this._tierBackendProperties = tierBackendProperties;
    }

    public String getName() {
        return this._name;
    }

    public String getSegmentSelectorType() {
        return this._segmentSelectorType;
    }

    public String getSegmentAge() {
        return this._segmentAge;
    }

    public String getStorageType() {
        return this._storageType;
    }

    public String getServerTag() {
        return this._serverTag;
    }

    @Nullable
    public String getTierBackend() {
        return this._tierBackend;
    }

    @Nullable
    public Map<String, String> getTierBackendProperties() {
        return this._tierBackendProperties;
    }
}

