/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.EqualityUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class DateTimeFieldSpec
extends FieldSpec {
    private String _format;
    private String _granularity;

    public DateTimeFieldSpec() {
    }

    public DateTimeFieldSpec(String name, FieldSpec.DataType dataType, String format, String granularity) {
        super(name, dataType, true);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)dataType));
        DateTimeFormatSpec.validateFormat(format);
        DateTimeGranularitySpec.validateGranularity(granularity);
        this._format = format;
        this._granularity = granularity;
    }

    public DateTimeFieldSpec(String name, FieldSpec.DataType dataType, String format, String granularity, @Nullable Object defaultNullValue, @Nullable String transformFunction) {
        this(name, dataType, format, granularity);
        this.setDefaultNullValue(defaultNullValue);
        this.setTransformFunction(transformFunction);
    }

    @Override
    @JsonIgnore
    public FieldSpec.FieldType getFieldType() {
        return FieldSpec.FieldType.DATE_TIME;
    }

    @Override
    public void setSingleValueField(boolean isSingleValueField) {
        Preconditions.checkArgument((boolean)isSingleValueField, (Object)"Unsupported multi-value for date time field.");
    }

    public String getFormat() {
        return this._format;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public String getGranularity() {
        return this._granularity;
    }

    public void setGranularity(String granularity) {
        this._granularity = granularity;
    }

    @Override
    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = super.toJsonObject();
        jsonObject.put("format", this._format);
        jsonObject.put("granularity", this._granularity);
        return jsonObject;
    }

    public String toString() {
        return "< field type: DATE_TIME, field name: " + this._name + ", datatype: " + this._dataType + ", time column format: " + this._format + ", time field granularity: " + this._granularity + " >";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        DateTimeFieldSpec that = (DateTimeFieldSpec)o;
        return EqualityUtils.isEqual(this._format, that._format) && EqualityUtils.isEqual(this._granularity, that._granularity);
    }

    @Override
    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(super.hashCode(), this._format);
        result = EqualityUtils.hashCodeOf(result, this._granularity);
        return result;
    }

    public static enum TimeFormat {
        EPOCH,
        TIMESTAMP,
        SIMPLE_DATE_FORMAT;

    }
}

