/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.utils.JsonUtils;

public class RecordReaderFactory {
    private static final Map<String, String> DEFAULT_RECORD_READER_CLASS_MAP = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_RECORD_READER_CONFIG_CLASS_MAP = new HashMap<String, String>();
    static final String DEFAULT_AVRO_RECORD_READER_CLASS = "org.apache.pinot.plugin.inputformat.avro.AvroRecordReader";
    static final String DEFAULT_CSV_RECORD_READER_CLASS = "org.apache.pinot.plugin.inputformat.csv.CSVRecordReader";
    static final String DEFAULT_CSV_RECORD_READER_CONFIG_CLASS = "org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig";
    static final String DEFAULT_JSON_RECORD_READER_CLASS = "org.apache.pinot.plugin.inputformat.json.JSONRecordReader";
    static final String DEFAULT_THRIFT_RECORD_READER_CLASS = "org.apache.pinot.plugin.inputformat.thrift.ThriftRecordReader";
    static final String DEFAULT_THRIFT_RECORD_READER_CONFIG_CLASS = "org.apache.pinot.plugin.inputformat.thrift.ThriftRecordReaderConfig";
    static final String DEFAULT_ORC_RECORD_READER_CLASS = "org.apache.pinot.plugin.inputformat.orc.ORCRecordReader";
    static final String DEFAULT_PARQUET_RECORD_READER_CLASS = "org.apache.pinot.plugin.inputformat.parquet.ParquetRecordReader";
    static final String DEFAULT_PARQUET_RECORD_READER_CONFIG_CLASS = "org.apache.pinot.plugin.inputformat.parquet.ParquetRecordReaderConfig";

    private RecordReaderFactory() {
    }

    public static void register(String fileFormat, String recordReaderClassName, String recordReaderConfigClassName) {
        DEFAULT_RECORD_READER_CLASS_MAP.put(fileFormat.toUpperCase(), recordReaderClassName);
        DEFAULT_RECORD_READER_CONFIG_CLASS_MAP.put(fileFormat.toUpperCase(), recordReaderConfigClassName);
    }

    public static void register(FileFormat fileFormat, String recordReaderClassName, String recordReaderConfigClassName) {
        RecordReaderFactory.register(fileFormat.name(), recordReaderClassName, recordReaderConfigClassName);
    }

    public static RecordReaderConfig getRecordReaderConfigByClassName(String recordReaderConfigClassName, String readerConfigFile) throws IOException, ClassNotFoundException {
        return RecordReaderFactory.getRecordReaderConfigByClassName(recordReaderConfigClassName, new File(readerConfigFile));
    }

    public static RecordReaderConfig getRecordReaderConfigByClassName(String recordReaderConfigClassName, File readerConfigFile) throws IOException, ClassNotFoundException {
        Class<?> recordReaderConfigClass = PluginManager.get().loadClass(recordReaderConfigClassName);
        RecordReaderConfig recordReaderConfig = (RecordReaderConfig)JsonUtils.fileToObject(readerConfigFile, recordReaderConfigClass);
        return recordReaderConfig;
    }

    public static RecordReaderConfig getRecordReaderConfig(FileFormat fileFormat, String readerConfigFile) throws Exception {
        String fileFormatKey = fileFormat.name().toUpperCase();
        if (DEFAULT_RECORD_READER_CONFIG_CLASS_MAP.containsKey(fileFormatKey)) {
            return RecordReaderFactory.getRecordReaderConfigByClassName(DEFAULT_RECORD_READER_CONFIG_CLASS_MAP.get(fileFormatKey), readerConfigFile);
        }
        throw new UnsupportedOperationException("No supported RecordReader found for file format - '" + fileFormat + "'");
    }

    public static RecordReaderConfig getRecordReaderConfig(FileFormat fileFormat, Map<String, String> configs) throws ClassNotFoundException, IOException {
        String readerConfigClassName = RecordReaderFactory.getRecordReaderConfigClassName(fileFormat.toString());
        if (readerConfigClassName != null) {
            JsonNode jsonNode = new ObjectMapper().valueToTree(configs);
            Class<?> clazz = PluginManager.get().loadClass(readerConfigClassName);
            return (RecordReaderConfig)JsonUtils.jsonNodeToObject(jsonNode, clazz);
        }
        return null;
    }

    public static RecordReader getRecordReaderByClass(String recordReaderClassName, File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws Exception {
        RecordReader recordReader = (RecordReader)PluginManager.get().createInstance(recordReaderClassName);
        recordReader.init(dataFile, fieldsToRead, recordReaderConfig);
        return recordReader;
    }

    public static RecordReader getRecordReader(FileFormat fileFormat, File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws Exception {
        return RecordReaderFactory.getRecordReader(fileFormat.name(), dataFile, fieldsToRead, recordReaderConfig);
    }

    public static RecordReader getRecordReader(String fileFormat, File dataFile, Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws Exception {
        String recordReaderClassName = DEFAULT_RECORD_READER_CLASS_MAP.get(fileFormat.toUpperCase());
        if (recordReaderClassName == null) {
            throw new UnsupportedOperationException("No supported RecordReader found for file format - '" + fileFormat + "'");
        }
        return RecordReaderFactory.getRecordReaderByClass(recordReaderClassName, dataFile, fieldsToRead, recordReaderConfig);
    }

    public static String getRecordReaderClassName(String fileFormatStr) {
        return DEFAULT_RECORD_READER_CLASS_MAP.get(fileFormatStr.toUpperCase());
    }

    public static String getRecordReaderConfigClassName(String fileFormatStr) {
        return DEFAULT_RECORD_READER_CONFIG_CLASS_MAP.get(fileFormatStr.toUpperCase());
    }

    static {
        RecordReaderFactory.register(FileFormat.AVRO, DEFAULT_AVRO_RECORD_READER_CLASS, null);
        RecordReaderFactory.register(FileFormat.GZIPPED_AVRO, DEFAULT_AVRO_RECORD_READER_CLASS, null);
        RecordReaderFactory.register(FileFormat.CSV, DEFAULT_CSV_RECORD_READER_CLASS, DEFAULT_CSV_RECORD_READER_CONFIG_CLASS);
        RecordReaderFactory.register(FileFormat.JSON, DEFAULT_JSON_RECORD_READER_CLASS, null);
        RecordReaderFactory.register(FileFormat.THRIFT, DEFAULT_THRIFT_RECORD_READER_CLASS, DEFAULT_THRIFT_RECORD_READER_CONFIG_CLASS);
        RecordReaderFactory.register(FileFormat.ORC, DEFAULT_ORC_RECORD_READER_CLASS, null);
        RecordReaderFactory.register(FileFormat.PARQUET, DEFAULT_PARQUET_RECORD_READER_CLASS, DEFAULT_PARQUET_RECORD_READER_CONFIG_CLASS);
    }
}

