/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.spi.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArray
implements Comparable<ByteArray>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteArray.class);
    private static final MethodHandle COMPARE_UNSIGNED;
    private final byte[] _bytes;

    public ByteArray(byte[] bytes) {
        this._bytes = bytes;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public int length() {
        return this._bytes.length;
    }

    public String toHexString() {
        return BytesUtils.toHexString(this._bytes);
    }

    public String toString() {
        return this.toHexString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray bytes = (ByteArray)o;
        return Arrays.equals(this._bytes, bytes._bytes);
    }

    public int hashCode() {
        int hash = 1;
        int i = 0;
        while (i + 7 < this._bytes.length) {
            hash = -1807454463 * hash + 1742810335 * this._bytes[i] + 887503681 * this._bytes[i + 1] + 28629151 * this._bytes[i + 2] + 923521 * this._bytes[i + 3] + 29791 * this._bytes[i + 4] + 961 * this._bytes[i + 5] + 31 * this._bytes[i + 6] + this._bytes[i + 7];
            i += 8;
        }
        while (i < this._bytes.length) {
            hash = 31 * hash + this._bytes[i];
            ++i;
        }
        return hash;
    }

    @Override
    public int compareTo(@Nonnull ByteArray that) {
        if (this == that) {
            return 0;
        }
        return ByteArray.compare(this._bytes, that._bytes);
    }

    public static int compare(byte[] left, byte[] right) {
        return ByteArray.compare(left, 0, left.length, right, 0, right.length);
    }

    public static int compare(byte[] left, int leftFromIndex, int leftToIndex, byte[] right, int rightFromIndex, int rightToIndex) {
        if (COMPARE_UNSIGNED != null) {
            try {
                return COMPARE_UNSIGNED.invokeExact(left, leftFromIndex, leftToIndex, right, rightFromIndex, rightToIndex);
            }
            catch (ArrayIndexOutOfBoundsException outOfBounds) {
                throw outOfBounds;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ByteArray.compareFallback(left, leftFromIndex, leftToIndex, right, rightFromIndex, rightToIndex);
    }

    private static int compareFallback(byte[] left, int leftFromIndex, int leftToIndex, byte[] right, int rightFromIndex, int rightToIndex) {
        int len1 = leftToIndex - leftFromIndex;
        int len2 = rightToIndex - rightFromIndex;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            int bi;
            int ai = Byte.toUnsignedInt(left[k + leftFromIndex]);
            if (ai == (bi = Byte.toUnsignedInt(right[k + rightFromIndex]))) continue;
            return ai - bi;
        }
        return len1 - len2;
    }

    static {
        MethodHandle compareUnsigned = null;
        try {
            compareUnsigned = MethodHandles.publicLookup().findStatic(Arrays.class, "compareUnsigned", MethodType.methodType(Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE));
        }
        catch (Exception ignored) {
            LOGGER.warn("Arrays.compareUnsigned unavailable - this may have a performance impact (are you using JDK8?)");
        }
        COMPARE_UNSIGNED = compareUnsigned;
    }
}

