/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeFormatPatternSpec {
    public static final DateTimeZone DEFAULT_DATE_TIME_ZONE = DateTimeZone.UTC;
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final DateTimeFormatPatternSpec EPOCH = new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.EPOCH);
    public static final DateTimeFormatPatternSpec TIMESTAMP = new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.TIMESTAMP);
    private static final Pattern SDF_PATTERN_WITH_TIMEZONE = Pattern.compile("^(.+)( tz[ ]*\\((.+)\\))[ ]*");
    private static final int SDF_PATTERN_GROUP = 1;
    private static final int TIME_ZONE_GROUP = 3;
    private final DateTimeFieldSpec.TimeFormat _timeFormat;
    private final String _sdfPattern;
    private final DateTimeZone _dateTimeZone;
    private final transient DateTimeFormatter _dateTimeFormatter;

    public DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat timeFormat) {
        this(timeFormat, null);
    }

    public DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat timeFormat, @Nullable String sdfPatternWithTz) {
        this._timeFormat = timeFormat;
        if (timeFormat == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)sdfPatternWithTz), (Object)"Must provide SIMPLE_DATE_FORMAT pattern");
            Matcher m = SDF_PATTERN_WITH_TIMEZONE.matcher(sdfPatternWithTz);
            if (m.find()) {
                this._sdfPattern = m.group(1).trim();
                String timeZone = m.group(3).trim();
                try {
                    this._dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timeZone));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid time zone: " + timeZone);
                }
            } else {
                this._sdfPattern = sdfPatternWithTz;
                this._dateTimeZone = DEFAULT_DATE_TIME_ZONE;
            }
            try {
                this._dateTimeFormatter = DateTimeFormat.forPattern((String)this._sdfPattern).withZone(this._dateTimeZone).withLocale(DEFAULT_LOCALE);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid SIMPLE_DATE_FORMAT pattern: " + this._sdfPattern);
            }
        } else {
            this._sdfPattern = null;
            this._dateTimeZone = DEFAULT_DATE_TIME_ZONE;
            this._dateTimeFormatter = null;
        }
    }

    public DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat timeFormat, @Nullable String sdfPattern, @Nullable String timeZone) {
        this._timeFormat = timeFormat;
        if (this._timeFormat == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)sdfPattern), (Object)"Must provide SIMPLE_DATE_FORMAT pattern");
            this._sdfPattern = sdfPattern;
            if (timeZone != null) {
                try {
                    this._dateTimeZone = DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timeZone));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid time zone: " + timeZone);
                }
            } else {
                this._dateTimeZone = DEFAULT_DATE_TIME_ZONE;
            }
            try {
                this._dateTimeFormatter = DateTimeFormat.forPattern((String)this._sdfPattern).withZone(this._dateTimeZone).withLocale(DEFAULT_LOCALE);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid SIMPLE_DATE_FORMAT pattern: " + this._sdfPattern);
            }
        } else {
            this._sdfPattern = null;
            this._dateTimeZone = DEFAULT_DATE_TIME_ZONE;
            this._dateTimeFormatter = null;
        }
    }

    public DateTimeFieldSpec.TimeFormat getTimeFormat() {
        return this._timeFormat;
    }

    public String getSdfPattern() {
        return this._sdfPattern;
    }

    public DateTimeZone getDateTimeZone() {
        return this._dateTimeZone;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this._dateTimeFormatter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeFormatPatternSpec that = (DateTimeFormatPatternSpec)o;
        return this._timeFormat == that._timeFormat && Objects.equals(this._sdfPattern, that._sdfPattern) && this._dateTimeZone.equals((Object)that._dateTimeZone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._timeFormat, this._sdfPattern, this._dateTimeZone});
    }

    public String toString() {
        return "DateTimeFormatPatternSpec{_timeFormat=" + this._timeFormat + ", _sdfPattern='" + this._sdfPattern + "', _dateTimeZone=" + this._dateTimeZone + "}";
    }
}

