/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.JsonUtils;

public class GenericRow
implements Serializable {
    public static final String MULTIPLE_RECORDS_KEY = "$MULTIPLE_RECORDS_KEY$";
    public static final String SKIP_RECORD_KEY = "$SKIP_RECORD_KEY$";
    private final Map<String, Object> _fieldToValueMap = new HashMap<String, Object>();
    private final Set<String> _nullValueFields = new HashSet<String>();

    public void init(GenericRow row) {
        this._fieldToValueMap.putAll(row._fieldToValueMap);
        this._nullValueFields.addAll(row._nullValueFields);
    }

    public Map<String, Object> getFieldToValueMap() {
        return Collections.unmodifiableMap(this._fieldToValueMap);
    }

    public Set<String> getNullValueFields() {
        return Collections.unmodifiableSet(this._nullValueFields);
    }

    public Object getValue(String fieldName) {
        return this._fieldToValueMap.get(fieldName);
    }

    public Object removeValue(String fieldName) {
        return this._fieldToValueMap.remove(fieldName);
    }

    public boolean isNullValue(String fieldName) {
        return this._nullValueFields.contains(fieldName);
    }

    public boolean hasNullValues() {
        return !this._nullValueFields.isEmpty();
    }

    public GenericRow copy() {
        GenericRow copy = new GenericRow();
        copy.init(this);
        for (Map.Entry<String, Object> entry : copy._fieldToValueMap.entrySet()) {
            entry.setValue(this.copy(entry.getValue()));
        }
        return copy;
    }

    private Object copy(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            HashMap map = new HashMap((Map)value);
            for (Map.Entry entry : map.entrySet()) {
                entry.setValue(this.copy(entry.getValue()));
            }
            return map;
        }
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>(((Collection)value).size());
            for (Object e : (Collection)value) {
                list.add(this.copy(e));
            }
            return list;
        }
        if (value.getClass().isArray()) {
            Object[] array = new Object[((Object[])value).length];
            int idx = 0;
            for (Object object : (Object[])value) {
                array[idx++] = this.copy(object);
            }
            return array;
        }
        return value;
    }

    public void putValue(String fieldName, @Nullable Object value) {
        this._fieldToValueMap.put(fieldName, value);
    }

    public PrimaryKey getPrimaryKey(List<String> primaryKeyColumns) {
        int numPrimaryKeyColumns = primaryKeyColumns.size();
        Object[] values = new Object[numPrimaryKeyColumns];
        for (int i = 0; i < numPrimaryKeyColumns; ++i) {
            Object value = this.getValue(primaryKeyColumns.get(i));
            if (value instanceof byte[]) {
                value = new ByteArray((byte[])value);
            }
            values[i] = value;
        }
        return new PrimaryKey(values);
    }

    public void putDefaultNullValue(String fieldName, Object defaultNullValue) {
        this._fieldToValueMap.put(fieldName, defaultNullValue);
        this._nullValueFields.add(fieldName);
    }

    public void addNullValueField(String fieldName) {
        this._nullValueFields.add(fieldName);
    }

    public boolean removeNullValueField(String fieldName) {
        return this._nullValueFields.remove(fieldName);
    }

    public void clear() {
        this._fieldToValueMap.clear();
        this._nullValueFields.clear();
    }

    public int hashCode() {
        return EqualityUtils.hashCodeOf(this._fieldToValueMap.hashCode(), this._nullValueFields.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GenericRow) {
            GenericRow that = (GenericRow)obj;
            return this._nullValueFields.equals(that._nullValueFields) && EqualityUtils.isEqual(this._fieldToValueMap, that._fieldToValueMap);
        }
        return false;
    }

    public String toString() {
        try {
            return JsonUtils.objectToPrettyString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void init(Map<String, Object> fieldToValueMap) {
        this._fieldToValueMap.putAll(fieldToValueMap);
    }

    @Deprecated
    @JsonIgnore
    public Set<Map.Entry<String, Object>> getEntrySet() {
        return this._fieldToValueMap.entrySet();
    }

    @Deprecated
    @JsonIgnore
    public String[] getFieldNames() {
        return this._fieldToValueMap.keySet().toArray(new String[0]);
    }

    @Deprecated
    public void putField(String fieldName, @Nullable Object value) {
        this._fieldToValueMap.put(fieldName, value);
    }

    @Deprecated
    public static GenericRow fromBytes(byte[] buffer) throws IOException {
        Map fieldMap = JsonUtils.bytesToObject(buffer, Map.class);
        GenericRow genericRow = new GenericRow();
        genericRow.init(fieldMap);
        return genericRow;
    }

    @Deprecated
    public byte[] toBytes() throws IOException {
        return JsonUtils.objectToBytes(this._fieldToValueMap);
    }

    @Deprecated
    public static GenericRow createOrReuseRow(GenericRow row) {
        if (row == null) {
            return new GenericRow();
        }
        row.clear();
        return row;
    }
}

