/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.spi.config.table.ingestion.ComplexTypeConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;

public class JsonUtils {
    public static final String VALUE_KEY = "";
    public static final String KEY_SEPARATOR = ".";
    public static final String ARRAY_INDEX_KEY = ".$index";
    public static final String WILDCARD = "*";
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    public static final ObjectReader DEFAULT_READER = DEFAULT_MAPPER.reader();
    public static final ObjectWriter DEFAULT_WRITER = DEFAULT_MAPPER.writer();
    public static final ObjectWriter DEFAULT_PRETTY_WRITER = DEFAULT_MAPPER.writerWithDefaultPrettyPrinter();
    public static final TypeReference<HashMap<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};

    private JsonUtils() {
    }

    public static <T> T stringToObject(String jsonString, Class<T> valueType) throws JsonProcessingException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonString);
    }

    public static <T> Pair<T, Map<String, Object>> inputStreamToObjectAndUnrecognizedProperties(InputStream jsonInputStream, Class<T> valueType) throws IOException {
        String jsonString = IOUtils.toString((InputStream)jsonInputStream, (Charset)StandardCharsets.UTF_8);
        return JsonUtils.stringToObjectAndUnrecognizedProperties(jsonString, valueType);
    }

    public static <T> Pair<T, Map<String, Object>> stringToObjectAndUnrecognizedProperties(String jsonString, Class<T> valueType) throws IOException {
        Object instance = DEFAULT_READER.forType(valueType).readValue(jsonString);
        Map<String, Object> inputJsonMap = JsonUtils.flatten((Map)DEFAULT_MAPPER.readValue(jsonString, MAP_TYPE_REFERENCE));
        String instanceJson = DEFAULT_MAPPER.writeValueAsString(instance);
        Map<String, Object> instanceJsonMap = JsonUtils.flatten((Map)DEFAULT_MAPPER.readValue(instanceJson, MAP_TYPE_REFERENCE));
        MapDifference difference = Maps.difference(inputJsonMap, instanceJsonMap);
        return Pair.of((Object)instance, (Object)difference.entriesOnlyOnLeft());
    }

    private static Map<String, Object> flatten(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(JsonUtils::flatten).collect(LinkedHashMap::new, (m, e) -> m.put("/" + (String)e.getKey(), e.getValue()), HashMap::putAll);
    }

    private static Stream<Map.Entry<String, Object>> flatten(Map.Entry<String, Object> entry) {
        if (entry == null) {
            return Stream.empty();
        }
        if (entry.getValue() instanceof Map) {
            return ((Map)entry.getValue()).entrySet().stream().flatMap(e -> JsonUtils.flatten(new AbstractMap.SimpleEntry((CallSite)((Object)((String)entry.getKey() + "/" + e.getKey())), e.getValue())));
        }
        if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            return IntStream.range(0, list.size()).mapToObj(i -> new AbstractMap.SimpleEntry((CallSite)((Object)((String)entry.getKey() + "/" + i)), list.get(i))).flatMap(JsonUtils::flatten);
        }
        return Stream.of(entry);
    }

    public static <T> T stringToObject(String jsonString, TypeReference<T> valueTypeRef) throws IOException {
        return (T)DEFAULT_READER.forType(valueTypeRef).readValue(jsonString);
    }

    public static JsonNode stringToJsonNode(String jsonString) throws IOException {
        return DEFAULT_READER.readTree(jsonString);
    }

    public static <T> T fileToObject(File jsonFile, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonFile);
    }

    public static <T> List<T> fileToList(File jsonFile, Class<T> valueType) throws IOException {
        return (List)DEFAULT_READER.forType((JavaType)DEFAULT_MAPPER.getTypeFactory().constructCollectionType(List.class, valueType)).readValue(jsonFile);
    }

    public static JsonNode fileToJsonNode(File jsonFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(jsonFile);){
            JsonNode jsonNode = DEFAULT_READER.readTree((InputStream)inputStream);
            return jsonNode;
        }
    }

    @Nullable
    public static JsonNode fileToFirstJsonNode(File jsonFile) throws IOException {
        JsonFactory jf = new JsonFactory();
        try (FileInputStream inputStream = new FileInputStream(jsonFile);){
            JsonNode jsonNode;
            block15: {
                JsonParser jp;
                block13: {
                    JsonNode jsonNode2;
                    block14: {
                        jp = jf.createParser((InputStream)inputStream);
                        try {
                            jp.setCodec((ObjectCodec)DEFAULT_MAPPER);
                            jp.nextToken();
                            if (!jp.hasCurrentToken()) break block13;
                            jsonNode2 = (JsonNode)DEFAULT_MAPPER.readTree(jp);
                            if (jp == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (jp != null) {
                                try {
                                    jp.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        jp.close();
                    }
                    return jsonNode2;
                }
                jsonNode = null;
                if (jp == null) break block15;
                jp.close();
            }
            return jsonNode;
        }
    }

    public static <T> T inputStreamToObject(InputStream jsonInputStream, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonInputStream);
    }

    public static JsonNode inputStreamToJsonNode(InputStream jsonInputStream) throws IOException {
        return DEFAULT_READER.readTree(jsonInputStream);
    }

    public static <T> T bytesToObject(byte[] jsonBytes, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonBytes);
    }

    public static JsonNode bytesToJsonNode(byte[] jsonBytes) throws IOException {
        return DEFAULT_READER.readTree((InputStream)new ByteArrayInputStream(jsonBytes));
    }

    public static <T> T jsonNodeToObject(JsonNode jsonNode, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonNode);
    }

    public static <T> T jsonNodeToObject(JsonNode jsonNode, TypeReference<T> valueTypeRef) throws IOException {
        return (T)DEFAULT_READER.forType(valueTypeRef).readValue(jsonNode);
    }

    public static Map<String, Object> jsonNodeToMap(JsonNode jsonNode) throws IOException {
        return (Map)DEFAULT_READER.forType(MAP_TYPE_REFERENCE).readValue(jsonNode);
    }

    public static String objectToString(Object object) throws JsonProcessingException {
        return DEFAULT_WRITER.writeValueAsString(object);
    }

    public static String objectToPrettyString(Object object) throws JsonProcessingException {
        return DEFAULT_PRETTY_WRITER.writeValueAsString(object);
    }

    public static byte[] objectToBytes(Object object) throws JsonProcessingException {
        return DEFAULT_WRITER.writeValueAsBytes(object);
    }

    public static JsonNode objectToJsonNode(Object object) {
        return DEFAULT_MAPPER.valueToTree(object);
    }

    public static ObjectNode newObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    public static ArrayNode newArrayNode() {
        return JsonNodeFactory.instance.arrayNode();
    }

    public static Object extractValue(@Nullable JsonNode jsonValue, FieldSpec fieldSpec) {
        if (fieldSpec.isSingleValueField()) {
            if (jsonValue != null && !jsonValue.isNull()) {
                return JsonUtils.extractSingleValue(jsonValue, fieldSpec.getDataType());
            }
            return null;
        }
        if (jsonValue != null && !jsonValue.isNull()) {
            if (jsonValue.isArray()) {
                int numValues = jsonValue.size();
                if (numValues != 0) {
                    Object[] values = new Object[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        values[i] = JsonUtils.extractSingleValue(jsonValue.get(i), fieldSpec.getDataType());
                    }
                    return values;
                }
                return null;
            }
            return new Object[]{JsonUtils.extractSingleValue(jsonValue, fieldSpec.getDataType())};
        }
        return null;
    }

    private static Object extractSingleValue(JsonNode jsonValue, FieldSpec.DataType dataType) {
        Preconditions.checkArgument((boolean)jsonValue.isValueNode());
        switch (dataType) {
            case INT: {
                return jsonValue.asInt();
            }
            case LONG: {
                return jsonValue.asLong();
            }
            case FLOAT: {
                return Float.valueOf((float)jsonValue.asDouble());
            }
            case DOUBLE: {
                return jsonValue.asDouble();
            }
            case BOOLEAN: {
                return jsonValue.asBoolean();
            }
            case TIMESTAMP: 
            case STRING: 
            case JSON: {
                return jsonValue.asText();
            }
            case BYTES: {
                try {
                    return jsonValue.binaryValue();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to extract binary value");
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported data type %s", new Object[]{dataType}));
    }

    public static List<Map<String, String>> flatten(JsonNode node) {
        if (node.isNull()) {
            return Collections.emptyList();
        }
        if (node.isValueNode()) {
            return Collections.singletonList(Collections.singletonMap(VALUE_KEY, node.asText()));
        }
        if (node.isArray()) {
            ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
            int numChildren = node.size();
            for (int i = 0; i < numChildren; ++i) {
                JsonNode childNode = node.get(i);
                String arrayIndexValue = Integer.toString(i);
                List<Map<String, String>> childResults = JsonUtils.flatten(childNode);
                for (Map<String, String> childResult : childResults) {
                    if (childResult.isEmpty()) continue;
                    TreeMap<Object, String> result = new TreeMap<Object, String>();
                    for (Map.Entry<String, String> entry : childResult.entrySet()) {
                        result.put(KEY_SEPARATOR + entry.getKey(), entry.getValue());
                    }
                    result.put(ARRAY_INDEX_KEY, arrayIndexValue);
                    results.add(result);
                }
            }
            return results;
        }
        assert (node.isObject());
        TreeMap<String, String> nonNestedResult = new TreeMap<String, String>();
        ArrayList<List<Map<String, String>>> nestedResultsList = new ArrayList<List<Map<String, String>>>();
        Iterator fieldIterator = node.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry fieldEntry = (Map.Entry)fieldIterator.next();
            JsonNode childNode = (JsonNode)fieldEntry.getValue();
            List<Map<String, String>> childResults = JsonUtils.flatten(childNode);
            int numChildResults = childResults.size();
            if (numChildResults == 0) continue;
            String prefix = KEY_SEPARATOR + (String)fieldEntry.getKey();
            if (numChildResults == 1) {
                Map<String, String> childResult = childResults.get(0);
                for (Map.Entry<String, String> entry : childResult.entrySet()) {
                    nonNestedResult.put(prefix + entry.getKey(), entry.getValue());
                }
                continue;
            }
            ArrayList prefixedResults = new ArrayList(numChildResults);
            for (Map<String, String> childResult : childResults) {
                if (childResult.isEmpty()) continue;
                TreeMap<CallSite, String> prefixedResult = new TreeMap<CallSite, String>();
                for (Map.Entry<String, String> entry : childResult.entrySet()) {
                    prefixedResult.put((CallSite)((Object)(prefix + entry.getKey())), entry.getValue());
                }
                prefixedResults.add(prefixedResult);
            }
            int numPrefixedResults = prefixedResults.size();
            if (numPrefixedResults == 0) continue;
            if (numPrefixedResults == 1) {
                nonNestedResult.putAll((Map)prefixedResults.get(0));
                continue;
            }
            nestedResultsList.add(prefixedResults);
        }
        int nestedResultsListSize = nestedResultsList.size();
        if (nestedResultsListSize == 0) {
            if (nonNestedResult.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(nonNestedResult);
        }
        if (nestedResultsListSize == 1) {
            List nestedResults = (List)nestedResultsList.get(0);
            for (Map nestedResult : nestedResults) {
                nestedResult.putAll(nonNestedResult);
            }
            return nestedResults;
        }
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        JsonUtils.unnestResults((List)nestedResultsList.get(0), nestedResultsList, 1, nonNestedResult, results);
        return results;
    }

    private static void unnestResults(List<Map<String, String>> currentResults, List<List<Map<String, String>>> nestedResultsList, int index, Map<String, String> nonNestedResult, List<Map<String, String>> outputResults) {
        int nestedResultsListSize = nestedResultsList.size();
        if (nestedResultsListSize == index) {
            for (Map<String, String> currentResult : currentResults) {
                currentResult.putAll(nonNestedResult);
                outputResults.add(currentResult);
            }
        } else {
            List<Map<String, String>> nestedResults = nestedResultsList.get(index);
            int numCurrentResults = currentResults.size();
            int numNestedResults = nestedResults.size();
            ArrayList<Map<String, String>> newCurrentResults = new ArrayList<Map<String, String>>(numCurrentResults * numNestedResults);
            for (Map<String, String> currentResult : currentResults) {
                for (Map<String, String> nestedResult : nestedResults) {
                    TreeMap<String, String> newCurrentResult = new TreeMap<String, String>(currentResult);
                    newCurrentResult.putAll(nestedResult);
                    newCurrentResults.add(newCurrentResult);
                }
            }
            JsonUtils.unnestResults(newCurrentResults, nestedResultsList, index + 1, nonNestedResult, outputResults);
        }
    }

    public static Schema getPinotSchemaFromJsonFile(File jsonFile, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit, @Nullable List<String> fieldsToUnnest, String delimiter, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson) throws IOException {
        JsonNode jsonNode = JsonUtils.fileToFirstJsonNode(jsonFile);
        if (fieldsToUnnest == null) {
            fieldsToUnnest = new ArrayList<String>();
        }
        Preconditions.checkNotNull((Object)jsonNode, (Object)"the JSON data shall be an object but it is null");
        Preconditions.checkState((boolean)jsonNode.isObject(), (Object)"the JSON data shall be an object");
        return JsonUtils.getPinotSchemaFromJsonNode(jsonNode, fieldTypeMap, timeUnit, fieldsToUnnest, delimiter, collectionNotUnnestedToJson);
    }

    public static Schema getPinotSchemaFromJsonNode(JsonNode jsonNode, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit, List<String> fieldsToUnnest, String delimiter, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson) {
        Schema pinotSchema = new Schema();
        Iterator fieldIterator = jsonNode.fields();
        while (fieldIterator.hasNext()) {
            Map.Entry fieldEntry = (Map.Entry)fieldIterator.next();
            JsonNode childNode = (JsonNode)fieldEntry.getValue();
            JsonUtils.inferPinotSchemaFromJsonNode(childNode, pinotSchema, (String)fieldEntry.getKey(), fieldTypeMap, timeUnit, fieldsToUnnest, delimiter, collectionNotUnnestedToJson);
        }
        return pinotSchema;
    }

    private static void inferPinotSchemaFromJsonNode(JsonNode jsonNode, Schema pinotSchema, String path, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit, List<String> fieldsToUnnest, String delimiter, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson) {
        if (jsonNode.isNull()) {
            return;
        }
        if (jsonNode.isValueNode()) {
            FieldSpec.DataType dataType = JsonUtils.valueOf(jsonNode);
            JsonUtils.addFieldToPinotSchema(pinotSchema, dataType, path, true, fieldTypeMap, timeUnit);
        } else if (jsonNode.isArray()) {
            int numChildren = jsonNode.size();
            if (numChildren == 0) {
                return;
            }
            JsonNode childNode = jsonNode.get(0);
            if (fieldsToUnnest.contains(path)) {
                JsonUtils.inferPinotSchemaFromJsonNode(childNode, pinotSchema, path, fieldTypeMap, timeUnit, fieldsToUnnest, delimiter, collectionNotUnnestedToJson);
            } else if (JsonUtils.shallConvertToJson(collectionNotUnnestedToJson, childNode)) {
                JsonUtils.addFieldToPinotSchema(pinotSchema, FieldSpec.DataType.STRING, path, true, fieldTypeMap, timeUnit);
            } else if (collectionNotUnnestedToJson == ComplexTypeConfig.CollectionNotUnnestedToJson.NON_PRIMITIVE && childNode.isValueNode()) {
                JsonUtils.addFieldToPinotSchema(pinotSchema, JsonUtils.valueOf(childNode), path, false, fieldTypeMap, timeUnit);
            }
        } else if (jsonNode.isObject()) {
            Iterator fieldIterator = jsonNode.fields();
            while (fieldIterator.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)fieldIterator.next();
                JsonNode childNode = (JsonNode)fieldEntry.getValue();
                JsonUtils.inferPinotSchemaFromJsonNode(childNode, pinotSchema, String.join((CharSequence)delimiter, path, (CharSequence)fieldEntry.getKey()), fieldTypeMap, timeUnit, fieldsToUnnest, delimiter, collectionNotUnnestedToJson);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unsupported json node type", jsonNode.getClass()));
        }
    }

    private static boolean shallConvertToJson(ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson, JsonNode childNode) {
        switch (collectionNotUnnestedToJson) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NON_PRIMITIVE: {
                return !childNode.isValueNode();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported collectionNotUnnestedToJson %s", new Object[]{collectionNotUnnestedToJson}));
    }

    public static FieldSpec.DataType valueOf(JsonNode jsonNode) {
        if (jsonNode.isInt()) {
            return FieldSpec.DataType.INT;
        }
        if (jsonNode.isLong()) {
            return FieldSpec.DataType.LONG;
        }
        if (jsonNode.isFloat()) {
            return FieldSpec.DataType.FLOAT;
        }
        if (jsonNode.isDouble()) {
            return FieldSpec.DataType.DOUBLE;
        }
        if (jsonNode.isBoolean()) {
            return FieldSpec.DataType.BOOLEAN;
        }
        if (jsonNode.isBinary()) {
            return FieldSpec.DataType.BYTES;
        }
        if (jsonNode.isBigDecimal()) {
            return FieldSpec.DataType.BIG_DECIMAL;
        }
        return FieldSpec.DataType.STRING;
    }

    private static void addFieldToPinotSchema(Schema pinotSchema, FieldSpec.DataType dataType, String name, boolean isSingleValueField, @Nullable Map<String, FieldSpec.FieldType> fieldTypeMap, @Nullable TimeUnit timeUnit) {
        if (fieldTypeMap == null) {
            pinotSchema.addField(new DimensionFieldSpec(name, dataType, isSingleValueField));
        } else {
            FieldSpec.FieldType fieldType = fieldTypeMap.getOrDefault(name, FieldSpec.FieldType.DIMENSION);
            Preconditions.checkNotNull((Object)((Object)fieldType), (String)"Field type not specified for field: %s", (Object)name);
            switch (fieldType) {
                case DIMENSION: {
                    pinotSchema.addField(new DimensionFieldSpec(name, dataType, isSingleValueField));
                    break;
                }
                case METRIC: {
                    Preconditions.checkState((boolean)isSingleValueField, (String)"Metric field: %s cannot be multi-valued", (Object)name);
                    pinotSchema.addField(new MetricFieldSpec(name, dataType));
                    break;
                }
                case DATE_TIME: {
                    Preconditions.checkState((boolean)isSingleValueField, (String)"Time field: %s cannot be multi-valued", (Object)name);
                    Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"Time unit cannot be null");
                    String format = "1:" + timeUnit.name() + ":EPOCH";
                    String granularity = "1:" + timeUnit.name();
                    pinotSchema.addField(new DateTimeFieldSpec(name, dataType, format, granularity));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported field type: " + fieldType + " for field: " + name);
                }
            }
        }
    }
}

