/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils.retry;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.pinot.spi.utils.retry.BaseRetryPolicy;

public class RandomDelayRetryPolicy
extends BaseRetryPolicy {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private final long _minDelayMs;
    private final long _maxDelayMs;

    public RandomDelayRetryPolicy(int maxNumAttempts, long minDelayMs, long maxDelayMs) {
        super(maxNumAttempts);
        Preconditions.checkState((maxDelayMs > minDelayMs ? 1 : 0) != 0, (Object)"RandomDelayRetryPolicy requires maxDelayMs > minDelayMs");
        this._minDelayMs = minDelayMs;
        this._maxDelayMs = maxDelayMs;
    }

    @Override
    protected long getDelayMs(int currentAttempt) {
        return this._minDelayMs + (long)(RANDOM.nextDouble() * (double)(this._maxDelayMs - this._minDelayMs));
    }
}

