/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.env;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;
import org.apache.pinot.spi.env.ConfigFilePropertyReaderFactory;
import org.apache.pinot.spi.env.PropertyConverter;
import org.apache.pinot.spi.ingestion.batch.spec.PinotFSSpec;
import org.apache.pinot.spi.utils.Obfuscator;

public class PinotConfiguration {
    public static final String CONFIG_PATHS_KEY = "config.paths";
    private final CompositeConfiguration _configuration;

    public PinotConfiguration() {
        this(new HashMap<String, Object>());
    }

    public PinotConfiguration(Configuration baseConfiguration) {
        this._configuration = new CompositeConfiguration(PinotConfiguration.computeConfigurationsFromSources(baseConfiguration, new HashMap<String, String>()));
    }

    public PinotConfiguration(Map<String, Object> baseProperties) {
        this(baseProperties, new HashMap<String, String>());
    }

    public PinotConfiguration(Map<String, Object> baseProperties, Map<String, String> environmentVariables) {
        this._configuration = new CompositeConfiguration(PinotConfiguration.computeConfigurationsFromSources(baseProperties, environmentVariables));
    }

    public PinotConfiguration(PinotFSSpec pinotFSSpec) {
        this(Optional.ofNullable(pinotFSSpec.getConfigs()).map(configs -> configs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue()))).orElseGet(() -> new HashMap()));
    }

    private static List<Configuration> computeConfigurationsFromSources(Configuration baseConfiguration, Map<String, String> environmentVariables) {
        return PinotConfiguration.computeConfigurationsFromSources(PinotConfiguration.relaxConfigurationKeys(baseConfiguration), environmentVariables);
    }

    private static List<Configuration> computeConfigurationsFromSources(Map<String, Object> baseProperties, Map<String, String> environmentVariables) {
        Map<String, Object> relaxedBaseProperties = PinotConfiguration.relaxProperties(baseProperties);
        Map<String, String> relaxedEnvVariables = PinotConfiguration.relaxEnvironmentVariables(environmentVariables);
        Stream<Configuration> propertiesFromConfigPaths = Stream.of(Optional.ofNullable(relaxedBaseProperties.get(CONFIG_PATHS_KEY)).map(Object::toString), Optional.ofNullable(relaxedEnvVariables.get(CONFIG_PATHS_KEY))).filter(Optional::isPresent).map(Optional::get).flatMap(configPaths -> Arrays.stream(configPaths.split(","))).map(PinotConfiguration::loadProperties);
        return Stream.concat(Stream.of(relaxedBaseProperties, relaxedEnvVariables).map(MapConfiguration::new), propertiesFromConfigPaths).collect(Collectors.toList());
    }

    private static String getProperty(String name, Configuration configuration) {
        return Optional.of(configuration.getStringArray(PinotConfiguration.relaxPropertyName(name))).filter(values -> ((String[])values).length > 0).map(Arrays::stream).map(stream -> stream.collect(Collectors.joining(","))).orElse(null);
    }

    private static Configuration loadProperties(String configPath) {
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            propertiesConfiguration.setIOFactory((PropertiesConfiguration.IOFactory)new ConfigFilePropertyReaderFactory());
            if (configPath.startsWith("classpath:")) {
                propertiesConfiguration.load(PinotConfiguration.class.getResourceAsStream(configPath.substring("classpath:".length())));
            } else {
                propertiesConfiguration.load(configPath);
            }
            return propertiesConfiguration;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Could not read properties from " + configPath, e);
        }
    }

    private static Map<String, Object> relaxConfigurationKeys(Configuration configuration) {
        return CommonsConfigurationUtils.getKeysStream(configuration).distinct().collect(Collectors.toMap(PinotConfiguration::relaxPropertyName, key -> configuration.getProperty(key)));
    }

    private static Map<String, String> relaxEnvironmentVariables(Map<String, String> environmentVariables) {
        return environmentVariables.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("PINOT_")).collect(Collectors.toMap(PinotConfiguration::relaxEnvVarName, Map.Entry::getValue));
    }

    private static String relaxEnvVarName(Map.Entry<String, String> envVarEntry) {
        return envVarEntry.getKey().substring(6).replace("_", ".").toLowerCase();
    }

    private static Map<String, Object> relaxProperties(Map<String, Object> properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(PinotConfiguration::relaxPropertyName, Map.Entry::getValue));
    }

    private static String relaxPropertyName(Map.Entry<String, Object> propertyEntry) {
        return PinotConfiguration.relaxPropertyName(propertyEntry.getKey());
    }

    private static String relaxPropertyName(String propertyName) {
        return propertyName.replace("-", "").replace("_", "").toLowerCase();
    }

    public void addProperty(String name, Object value) {
        this._configuration.addProperty(PinotConfiguration.relaxPropertyName(name), value);
    }

    public PinotConfiguration clone() {
        return new PinotConfiguration((Configuration)this._configuration);
    }

    public boolean containsKey(String key) {
        return this._configuration.containsKey(PinotConfiguration.relaxPropertyName(key));
    }

    public List<String> getKeys() {
        return CommonsConfigurationUtils.getKeys((Configuration)this._configuration);
    }

    public String getProperty(String name) {
        return PinotConfiguration.getProperty(name, (Configuration)this._configuration);
    }

    public boolean getProperty(String name, boolean defaultValue) {
        return this.getProperty(name, defaultValue, Boolean.class);
    }

    public <T> T getProperty(String name, Class<T> returnType) {
        return this.getProperty(name, null, returnType);
    }

    public double getProperty(String name, double defaultValue) {
        return this.getProperty(name, defaultValue, Double.class);
    }

    public int getProperty(String name, int defaultValue) {
        return this.getProperty(name, defaultValue, Integer.class);
    }

    public List<String> getProperty(String name, List<String> defaultValues) {
        return Optional.of(Arrays.stream(this._configuration.getStringArray(PinotConfiguration.relaxPropertyName(name))).collect(Collectors.toList())).filter(list -> !list.isEmpty()).orElse(defaultValues);
    }

    public long getProperty(String name, long defaultValue) {
        return this.getProperty(name, defaultValue, Long.class);
    }

    public String getProperty(String name, String defaultValue) {
        Object rawProperty = this.getRawProperty(name, defaultValue);
        if (rawProperty instanceof List) {
            return StringUtils.join((Object[])((ArrayList)rawProperty).toArray(), (char)',');
        }
        if (rawProperty == null) {
            return null;
        }
        return rawProperty.toString();
    }

    private <T> T getProperty(String name, T defaultValue, Class<T> returnType) {
        String relaxedPropertyName = PinotConfiguration.relaxPropertyName(name);
        if (!this._configuration.containsKey(relaxedPropertyName)) {
            return defaultValue;
        }
        return PropertyConverter.convert(this.getRawProperty(name, defaultValue), returnType);
    }

    public Object getRawProperty(String name) {
        return this.getRawProperty(name, null);
    }

    public Object getRawProperty(String name, Object defaultValue) {
        String relaxedPropertyName = PinotConfiguration.relaxPropertyName(name);
        if (!this._configuration.containsKey(relaxedPropertyName)) {
            return defaultValue;
        }
        return this._configuration.getProperty(relaxedPropertyName);
    }

    public void setProperty(String name, Object value) {
        this._configuration.setProperty(PinotConfiguration.relaxPropertyName(name), value);
    }

    public void clearProperty(String name) {
        this._configuration.clearProperty(PinotConfiguration.relaxPropertyName(name));
    }

    public PinotConfiguration subset(String prefix) {
        return new PinotConfiguration(this._configuration.subset(PinotConfiguration.relaxPropertyName(prefix)));
    }

    public Map<String, Object> toMap() {
        return CommonsConfigurationUtils.toMap((Configuration)this._configuration);
    }

    public String toString() {
        return new Obfuscator().toJsonString(this.toMap());
    }

    public boolean isEmpty() {
        return this._configuration.isEmpty();
    }
}

