/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

public class BooleanUtils {
    private BooleanUtils() {
    }

    public static boolean toBoolean(String booleanString) {
        return booleanString.equalsIgnoreCase("true") || booleanString.equals("1");
    }

    public static boolean toBoolean(Object booleanObject) {
        if (booleanObject instanceof String) {
            return BooleanUtils.toBoolean((String)booleanObject);
        }
        if (booleanObject instanceof Number) {
            return ((Number)booleanObject).intValue() != 0;
        }
        if (booleanObject instanceof Boolean) {
            return (Boolean)booleanObject;
        }
        throw new IllegalArgumentException("Illegal type for boolean conversion: " + booleanObject.getClass());
    }

    public static int toInt(String booleanString) {
        return BooleanUtils.toBoolean(booleanString) ? 1 : 0;
    }
}

