/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class StarTreeIndexConfig
extends BaseJsonConfig {
    private final List<String> _dimensionsSplitOrder;
    private final List<String> _skipStarNodeCreationForDimensions;
    private final List<String> _functionColumnPairs;
    private final int _maxLeafRecords;

    @JsonCreator
    public StarTreeIndexConfig(@JsonProperty(value="dimensionsSplitOrder", required=true) List<String> dimensionsSplitOrder, @JsonProperty(value="skipStarNodeCreationForDimensions") @Nullable List<String> skipStarNodeCreationForDimensions, @JsonProperty(value="functionColumnPairs", required=true) List<String> functionColumnPairs, @JsonProperty(value="maxLeafRecords") int maxLeafRecords) {
        Preconditions.checkArgument((dimensionsSplitOrder != null ? 1 : 0) != 0, (Object)"'dimensionsSplitOrder' must be configured");
        Preconditions.checkArgument((functionColumnPairs != null ? 1 : 0) != 0, (Object)"'functionColumnPairs' must be configured");
        this._dimensionsSplitOrder = dimensionsSplitOrder;
        this._skipStarNodeCreationForDimensions = skipStarNodeCreationForDimensions;
        this._functionColumnPairs = functionColumnPairs;
        this._maxLeafRecords = maxLeafRecords;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    @Nullable
    public List<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }

    public List<String> getFunctionColumnPairs() {
        return this._functionColumnPairs;
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }
}

