/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.IngestionConfig;
import org.apache.pinot.spi.config.table.QueryConfig;
import org.apache.pinot.spi.config.table.QuotaConfig;
import org.apache.pinot.spi.config.table.RoutingConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.TableCustomConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class TableConfig
extends BaseJsonConfig {
    public static final String TABLE_NAME_KEY = "tableName";
    public static final String TABLE_TYPE_KEY = "tableType";
    public static final String VALIDATION_CONFIG_KEY = "segmentsConfig";
    public static final String TENANT_CONFIG_KEY = "tenants";
    public static final String INDEXING_CONFIG_KEY = "tableIndexConfig";
    public static final String CUSTOM_CONFIG_KEY = "metadata";
    public static final String QUOTA_CONFIG_KEY = "quota";
    public static final String TASK_CONFIG_KEY = "task";
    public static final String ROUTING_CONFIG_KEY = "routing";
    public static final String QUERY_CONFIG_KEY = "query";
    public static final String INSTANCE_ASSIGNMENT_CONFIG_MAP_KEY = "instanceAssignmentConfigMap";
    public static final String FIELD_CONFIG_LIST_KEY = "fieldConfigList";
    public static final String UPSERT_CONFIG_KEY = "upsertConfig";
    public static final String INGESTION_CONFIG_KEY = "ingestionConfig";
    private static final String TABLE_NAME_FORBIDDEN_SUBSTRING = "__";
    @JsonPropertyDescription(value="The name for the table (with type suffix), e.g. \"myTable_OFFLINE\" (mandatory)")
    private final String _tableName;
    @JsonPropertyDescription(value="The type of the table (OFFLINE|REALTIME) (mandatory)")
    private final TableType _tableType;
    private SegmentsValidationAndRetentionConfig _validationConfig;
    private TenantConfig _tenantConfig;
    private IndexingConfig _indexingConfig;
    private TableCustomConfig _customConfig;
    @JsonPropertyDescription(value="Resource quota associated with this table")
    private QuotaConfig _quotaConfig;
    private TableTaskConfig _taskConfig;
    private RoutingConfig _routingConfig;
    private QueryConfig _queryConfig;
    private Map<InstancePartitionsType, InstanceAssignmentConfig> _instanceAssignmentConfigMap;
    private List<FieldConfig> _fieldConfigList;
    @JsonPropertyDescription(value="upsert related config")
    private UpsertConfig _upsertConfig;
    @JsonPropertyDescription(value="Config related to ingesting data into the table")
    private IngestionConfig _ingestionConfig;

    @JsonCreator
    public TableConfig(@JsonProperty(value="tableName", required=true) String tableName, @JsonProperty(value="tableType", required=true) String tableType, @JsonProperty(value="segmentsConfig", required=true) SegmentsValidationAndRetentionConfig validationConfig, @JsonProperty(value="tenants", required=true) TenantConfig tenantConfig, @JsonProperty(value="tableIndexConfig", required=true) IndexingConfig indexingConfig, @JsonProperty(value="metadata", required=true) TableCustomConfig customConfig, @JsonProperty(value="quota") @Nullable QuotaConfig quotaConfig, @JsonProperty(value="task") @Nullable TableTaskConfig taskConfig, @JsonProperty(value="routing") @Nullable RoutingConfig routingConfig, @JsonProperty(value="query") @Nullable QueryConfig queryConfig, @JsonProperty(value="instanceAssignmentConfigMap") @Nullable Map<InstancePartitionsType, InstanceAssignmentConfig> instanceAssignmentConfigMap, @JsonProperty(value="fieldConfigList") @Nullable List<FieldConfig> fieldConfigList, @JsonProperty(value="upsertConfig") @Nullable UpsertConfig upsertConfig, @JsonProperty(value="ingestionConfig") @Nullable IngestionConfig ingestionConfig) {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"'tableName' must be configured");
        Preconditions.checkArgument((!tableName.contains(TABLE_NAME_FORBIDDEN_SUBSTRING) ? 1 : 0) != 0, (Object)"'tableName' cannot contain double underscore ('__')");
        Preconditions.checkArgument((tableType != null ? 1 : 0) != 0, (Object)"'tableType' must be configured");
        Preconditions.checkArgument((validationConfig != null ? 1 : 0) != 0, (Object)"'segmentsConfig' must be configured");
        Preconditions.checkArgument((tenantConfig != null ? 1 : 0) != 0, (Object)"'tenants' must be configured");
        Preconditions.checkArgument((indexingConfig != null ? 1 : 0) != 0, (Object)"'tableIndexConfig' must be configured");
        Preconditions.checkArgument((customConfig != null ? 1 : 0) != 0, (Object)"'metadata' must be configured");
        this._tableType = TableType.valueOf(tableType.toUpperCase());
        this._tableName = TableNameBuilder.forType(this._tableType).tableNameWithType(tableName);
        this._validationConfig = validationConfig;
        this._tenantConfig = tenantConfig;
        this._indexingConfig = indexingConfig;
        this._customConfig = customConfig;
        this._quotaConfig = quotaConfig;
        this._taskConfig = taskConfig;
        this._routingConfig = routingConfig;
        this._queryConfig = queryConfig;
        this._instanceAssignmentConfigMap = instanceAssignmentConfigMap;
        this._fieldConfigList = fieldConfigList;
        this._upsertConfig = upsertConfig;
        this._ingestionConfig = ingestionConfig;
    }

    @JsonProperty(value="tableName")
    public String getTableName() {
        return this._tableName;
    }

    @JsonProperty(value="tableType")
    public TableType getTableType() {
        return this._tableType;
    }

    @JsonProperty(value="segmentsConfig")
    public SegmentsValidationAndRetentionConfig getValidationConfig() {
        return this._validationConfig;
    }

    public void setValidationConfig(SegmentsValidationAndRetentionConfig validationConfig) {
        this._validationConfig = validationConfig;
    }

    @JsonProperty(value="tenants")
    public TenantConfig getTenantConfig() {
        return this._tenantConfig;
    }

    public void setTenantConfig(TenantConfig tenantConfig) {
        this._tenantConfig = tenantConfig;
    }

    @JsonProperty(value="tableIndexConfig")
    public IndexingConfig getIndexingConfig() {
        return this._indexingConfig;
    }

    public void setIndexingConfig(IndexingConfig indexingConfig) {
        this._indexingConfig = indexingConfig;
    }

    @JsonProperty(value="metadata")
    public TableCustomConfig getCustomConfig() {
        return this._customConfig;
    }

    public void setCustomConfig(TableCustomConfig customConfig) {
        this._customConfig = customConfig;
    }

    @JsonProperty(value="quota")
    @Nullable
    public QuotaConfig getQuotaConfig() {
        return this._quotaConfig;
    }

    public void setQuotaConfig(QuotaConfig quotaConfig) {
        this._quotaConfig = quotaConfig;
    }

    @JsonProperty(value="task")
    @Nullable
    public TableTaskConfig getTaskConfig() {
        return this._taskConfig;
    }

    public void setTaskConfig(TableTaskConfig taskConfig) {
        this._taskConfig = taskConfig;
    }

    @JsonProperty(value="routing")
    @Nullable
    public RoutingConfig getRoutingConfig() {
        return this._routingConfig;
    }

    public void setRoutingConfig(RoutingConfig routingConfig) {
        this._routingConfig = routingConfig;
    }

    @JsonProperty(value="query")
    @Nullable
    public QueryConfig getQueryConfig() {
        return this._queryConfig;
    }

    public void setQueryConfig(QueryConfig queryConfig) {
        this._queryConfig = queryConfig;
    }

    @JsonProperty(value="instanceAssignmentConfigMap")
    @Nullable
    public Map<InstancePartitionsType, InstanceAssignmentConfig> getInstanceAssignmentConfigMap() {
        return this._instanceAssignmentConfigMap;
    }

    public void setInstanceAssignmentConfigMap(Map<InstancePartitionsType, InstanceAssignmentConfig> instanceAssignmentConfigMap) {
        this._instanceAssignmentConfigMap = instanceAssignmentConfigMap;
    }

    @JsonProperty(value="fieldConfigList")
    @Nullable
    public List<FieldConfig> getFieldConfigList() {
        return this._fieldConfigList;
    }

    public void setFieldConfigList(List<FieldConfig> fieldConfigList) {
        this._fieldConfigList = fieldConfigList;
    }

    @Nullable
    public UpsertConfig getUpsertConfig() {
        return this._upsertConfig;
    }

    public void setUpsertConfig(UpsertConfig upsertConfig) {
        this._upsertConfig = upsertConfig;
    }

    @JsonProperty(value="ingestionConfig")
    @Nullable
    public IngestionConfig getIngestionConfig() {
        return this._ingestionConfig;
    }

    public void setIngestionConfig(IngestionConfig ingestionConfig) {
        this._ingestionConfig = ingestionConfig;
    }
}

