/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class UpsertConfig
extends BaseJsonConfig {
    private final List<String> _primaryKeyColumns;
    private final String _offsetColumn;
    private final String _validFromColumn;
    private final String _validUntilColumn;

    @JsonCreator
    public UpsertConfig(@JsonProperty(value="primaryKeyColumns") List<String> primaryKeyColumns, @JsonProperty(value="offsetColumn") String offsetColumn, @JsonProperty(value="validFromColumn") String validFromColumn, @JsonProperty(value="validUntilColumn") String validUntilColumn) {
        Preconditions.checkArgument((primaryKeyColumns != null && primaryKeyColumns.size() == 1 ? 1 : 0) != 0, (Object)"'primaryKeyColumns' must be configured with exact one column");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)offsetColumn), (Object)"'offsetColumn' must be configured");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)validFromColumn), (Object)"'validFromColumn' must be configured");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)validUntilColumn), (Object)"'validUntilColumn' must be configured");
        this._primaryKeyColumns = primaryKeyColumns;
        this._offsetColumn = offsetColumn;
        this._validFromColumn = validFromColumn;
        this._validUntilColumn = validUntilColumn;
    }

    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    public String getOffsetColumn() {
        return this._offsetColumn;
    }

    public String getValidFromColumn() {
        return this._validFromColumn;
    }

    public String getValidUntilColumn() {
        return this._validUntilColumn;
    }
}

