/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table.assignment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class InstanceTagPoolConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Tag of the instances to select (mandatory)")
    private final String _tag;
    @JsonPropertyDescription(value="Whether to use pool based selection, false by default")
    private final boolean _poolBased;
    @JsonPropertyDescription(value="Number of pools to select for pool based selection, contradict to pools, select all pools if neither of them are specified")
    private final int _numPools;
    @JsonPropertyDescription(value="Pools to select for pool based selection, contradict to numPools, select all pools if neither of them are specified")
    private final List<Integer> _pools;

    @JsonCreator
    public InstanceTagPoolConfig(@JsonProperty(value="tag", required=true) String tag, @JsonProperty(value="poolBased") boolean poolBased, @JsonProperty(value="numPools") int numPools, @JsonProperty(value="pools") @Nullable List<Integer> pools) {
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"'tag' must be configured");
        this._tag = tag;
        this._poolBased = poolBased;
        this._numPools = numPools;
        this._pools = pools;
    }

    public String getTag() {
        return this._tag;
    }

    public boolean isPoolBased() {
        return this._poolBased;
    }

    public int getNumPools() {
        return this._numPools;
    }

    @Nullable
    public List<Integer> getPools() {
        return this._pools;
    }
}

