/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;

public class RecordReaderUtils {
    public static final String GZIP_FILE_EXTENSION = ".gz";

    private RecordReaderUtils() {
    }

    public static BufferedReader getBufferedReader(File dataFile) throws IOException {
        return new BufferedReader(new InputStreamReader(RecordReaderUtils.getInputStream(dataFile), StandardCharsets.UTF_8));
    }

    public static BufferedInputStream getBufferedInputStream(File dataFile) throws IOException {
        return new BufferedInputStream(RecordReaderUtils.getInputStream(dataFile));
    }

    public static InputStream getInputStream(File dataFile) throws IOException {
        if (dataFile.getName().endsWith(GZIP_FILE_EXTENSION)) {
            return new GZIPInputStream(new FileInputStream(dataFile));
        }
        return new FileInputStream(dataFile);
    }

    @Nullable
    public static Object convert(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return RecordReaderUtils.convertMultiValue((Collection)value);
        }
        return RecordReaderUtils.convertSingleValue(value);
    }

    @Nullable
    public static Object convertSingleValue(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer byteBufferValue = (ByteBuffer)value;
            byte[] bytesValue = new byte[byteBufferValue.remaining()];
            byteBufferValue.get(bytesValue);
            return bytesValue;
        }
        if (value instanceof Number) {
            return value;
        }
        return value.toString();
    }

    @Nullable
    public static Object convertMultiValue(@Nullable Collection values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        int numValues = values.size();
        Object[] array = new Object[numValues];
        int index = 0;
        for (Object value : values) {
            Object convertedValue = RecordReaderUtils.convertSingleValue(value);
            if (convertedValue == null || convertedValue.toString().equals("")) continue;
            array[index++] = convertedValue;
        }
        if (index == numValues) {
            return array;
        }
        if (index == 0) {
            return null;
        }
        return Arrays.copyOf(array, index);
    }
}

