/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public abstract class CommonsConfigurationUtils {
    public static PropertiesConfiguration fromFile(File file) {
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            propertiesConfiguration.setFile(file);
            if (file.exists()) {
                propertiesConfiguration.load((InputStream)new FileInputStream(file));
            }
            return propertiesConfiguration;
        }
        catch (FileNotFoundException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Iterable<String> getIterable(Iterator<String> keys) {
        return () -> keys;
    }

    public static Stream<String> getKeysStream(Configuration configuration) {
        return StreamSupport.stream(CommonsConfigurationUtils.getIterable(configuration.getKeys()).spliterator(), false);
    }

    public static List<String> getKeys(Configuration configuration) {
        return CommonsConfigurationUtils.getKeysStream(configuration).collect(Collectors.toList());
    }

    public static Map<String, Object> toMap(Configuration configuration) {
        return CommonsConfigurationUtils.getKeysStream(configuration).collect(Collectors.toMap(key -> key, key -> CommonsConfigurationUtils.mapValue(key, configuration)));
    }

    private static Object mapValue(String key, Configuration configuration) {
        return Optional.of(configuration.getStringArray(key)).filter(values -> ((String[])values).length > 1).map(values -> Arrays.stream(values).collect(Collectors.joining(","))).orElseGet(() -> configuration.getProperty(key));
    }
}

