/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.PinotFS;

public class LocalPinotFS
extends PinotFS {
    @Override
    public void init(PinotConfiguration configuration) {
    }

    @Override
    public boolean mkdir(URI uri) throws IOException {
        FileUtils.forceMkdir((File)LocalPinotFS.toFile(uri));
        return true;
    }

    @Override
    public boolean delete(URI segmentUri, boolean forceDelete) throws IOException {
        File file = LocalPinotFS.toFile(segmentUri);
        if (file.isDirectory()) {
            if (this.listFiles(segmentUri, false).length > 0 && !forceDelete) {
                return false;
            }
        } else {
            return FileUtils.deleteQuietly((File)file);
        }
        FileUtils.deleteDirectory((File)file);
        return true;
    }

    @Override
    public boolean doMove(URI srcUri, URI dstUri) throws IOException {
        File srcFile = LocalPinotFS.toFile(srcUri);
        File dstFile = LocalPinotFS.toFile(dstUri);
        if (srcFile.isDirectory()) {
            FileUtils.moveDirectory((File)srcFile, (File)dstFile);
        } else {
            FileUtils.moveFile((File)srcFile, (File)dstFile);
        }
        return true;
    }

    @Override
    public boolean copy(URI srcUri, URI dstUri) throws IOException {
        LocalPinotFS.copy(LocalPinotFS.toFile(srcUri), LocalPinotFS.toFile(dstUri));
        return true;
    }

    @Override
    public boolean exists(URI fileUri) {
        return LocalPinotFS.toFile(fileUri).exists();
    }

    @Override
    public long length(URI fileUri) {
        File file = LocalPinotFS.toFile(fileUri);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File is directory");
        }
        return FileUtils.sizeOf((File)file);
    }

    @Override
    public String[] listFiles(URI fileUri, boolean recursive) throws IOException {
        File file = LocalPinotFS.toFile(fileUri);
        if (!recursive) {
            return (String[])Arrays.stream(file.list()).map(s -> new File(file, (String)s)).map(File::getAbsolutePath).toArray(String[]::new);
        }
        return (String[])Files.walk(Paths.get(fileUri), new FileVisitOption[0]).filter(s -> !s.equals(file.toPath())).map(Path::toString).toArray(String[]::new);
    }

    @Override
    public void copyToLocalFile(URI srcUri, File dstFile) throws Exception {
        LocalPinotFS.copy(LocalPinotFS.toFile(srcUri), dstFile);
    }

    @Override
    public void copyFromLocalFile(File srcFile, URI dstUri) throws Exception {
        LocalPinotFS.copy(srcFile, LocalPinotFS.toFile(dstUri));
    }

    @Override
    public boolean isDirectory(URI uri) {
        return LocalPinotFS.toFile(uri).isDirectory();
    }

    @Override
    public long lastModified(URI uri) {
        return LocalPinotFS.toFile(uri).lastModified();
    }

    @Override
    public boolean touch(URI uri) throws IOException {
        File file = LocalPinotFS.toFile(uri);
        if (!file.exists()) {
            return file.createNewFile();
        }
        return file.setLastModified(System.currentTimeMillis());
    }

    @Override
    public InputStream open(URI uri) throws IOException {
        return new BufferedInputStream(new FileInputStream(LocalPinotFS.toFile(uri)));
    }

    private static File toFile(URI uri) {
        try {
            return new File(URLDecoder.decode(uri.getRawPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copy(File srcFile, File dstFile) throws IOException {
        if (dstFile.exists()) {
            FileUtils.deleteQuietly((File)dstFile);
        }
        if (srcFile.isDirectory()) {
            FileUtils.copyDirectory((File)srcFile, (File)dstFile);
        } else {
            FileUtils.copyFile((File)srcFile, (File)dstFile);
        }
    }
}

