/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.filesystem;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.LocalPinotFS;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.plugin.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotFSFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotFSFactory.class);
    private static final String LOCAL_PINOT_FS_SCHEME = "file";
    private static final String CLASS = "class";
    private static final Map<String, PinotFS> PINOT_FS_MAP = new HashMap<String, PinotFS>(){
        {
            this.put(PinotFSFactory.LOCAL_PINOT_FS_SCHEME, new LocalPinotFS());
        }
    };

    private PinotFSFactory() {
    }

    public static void register(String scheme, String fsClassName, PinotConfiguration fsConfiguration) {
        try {
            LOGGER.info("Initializing PinotFS for scheme {}, classname {}", (Object)scheme, (Object)fsClassName);
            PinotFS pinotFS = (PinotFS)PluginManager.get().createInstance(fsClassName);
            pinotFS.init(fsConfiguration);
            PINOT_FS_MAP.put(scheme, pinotFS);
        }
        catch (Exception e) {
            LOGGER.error("Could not instantiate file system for class {} with scheme {}", new Object[]{fsClassName, scheme, e});
            throw new RuntimeException(e);
        }
    }

    public static void init(PinotConfiguration fsFactoryConfig) {
        PinotConfiguration schemesConfiguration = fsFactoryConfig.subset(CLASS);
        List<String> schemes = schemesConfiguration.getKeys();
        if (!schemes.isEmpty()) {
            LOGGER.info("Did not find any fs classes in the configuration");
        }
        for (String scheme : schemes) {
            String fsClassName = schemesConfiguration.getProperty(scheme);
            PinotConfiguration fsConfiguration = fsFactoryConfig.subset(scheme);
            LOGGER.info("Got scheme {}, initializing class {}", (Object)scheme, (Object)fsClassName);
            PinotFSFactory.register(scheme, fsClassName, fsConfiguration);
        }
    }

    public static PinotFS create(String scheme) {
        PinotFS pinotFS = PINOT_FS_MAP.get(scheme);
        Preconditions.checkState((pinotFS != null ? 1 : 0) != 0, (String)"PinotFS for scheme: %s has not been initialized", (Object)scheme);
        return pinotFS;
    }

    public static boolean isSchemeSupported(String scheme) {
        return PINOT_FS_MAP.containsKey(scheme);
    }

    public static void shutdown() throws IOException {
        for (PinotFS pinotFS : PINOT_FS_MAP.values()) {
            pinotFS.close();
        }
    }
}

