/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EqualityUtils {
    private EqualityUtils() {
    }

    public static boolean isEqual(int left, int right) {
        return left == right;
    }

    public static boolean isEqual(long left, long right) {
        return left == right;
    }

    public static boolean isEqual(float left, float right) {
        return Float.floatToIntBits(left) == Float.floatToIntBits(right);
    }

    public static boolean isEqual(double left, double right) {
        return Double.doubleToLongBits(left) == Double.doubleToLongBits(right);
    }

    public static boolean isEqual(short left, short right) {
        return left == right;
    }

    public static boolean isEqual(char left, char right) {
        return left == right;
    }

    public static boolean isEqual(byte left, byte right) {
        return left == right;
    }

    public static boolean isEqual(@Nullable Object left, @Nullable Object right) {
        if (left != null && right != null) {
            return left.equals(right);
        }
        return left == right;
    }

    public static boolean isEqual(@Nullable Object[] left, @Nullable Object[] right) {
        return Arrays.deepEquals(left, right);
    }

    public static boolean isEqualIgnoreOrder(@Nullable List left, @Nullable List right) {
        if (left != null && right != null) {
            ArrayList sortedLeft = new ArrayList(left);
            ArrayList sortedRight = new ArrayList(right);
            Collections.sort(sortedLeft);
            Collections.sort(sortedRight);
            return sortedLeft.equals(sortedRight);
        }
        return left == right;
    }

    public static boolean isNullOrNotSameClass(@Nonnull Object left, @Nullable Object right) {
        return right == null || left.getClass() != right.getClass();
    }

    public static boolean isSameReference(@Nullable Object left, @Nullable Object right) {
        return left == right;
    }

    public static int hashCodeOf(@Nullable Object o) {
        if (o != null) {
            return o.hashCode();
        }
        return 0;
    }

    public static int hashCodeOf(int previousHashCode, @Nullable Object o) {
        return 37 * previousHashCode + EqualityUtils.hashCodeOf(o);
    }

    public static int hashCodeOf(int previousHashCode, int value) {
        return 37 * previousHashCode + value;
    }

    public static int hashCodeOf(int previousHashCode, long value) {
        return 37 * previousHashCode + (int)(value ^ value >>> 32);
    }

    public static int hashCodeOf(int previousHashCode, boolean value) {
        return 37 * previousHashCode + (value ? 1 : 0);
    }
}

