/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import groovy.text.SimpleTemplateEngine;
import groovy.text.TemplateEngine;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class GroovyTemplateUtils {
    private static final TemplateEngine GROOVY_TEMPLATE_ENGINE = new SimpleTemplateEngine();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static String renderTemplate(String template, Map<String, Object> newContext) throws IOException, ClassNotFoundException {
        Map<String, Object> contextMap = GroovyTemplateUtils.getDefaultContextMap();
        contextMap.putAll(newContext);
        return GROOVY_TEMPLATE_ENGINE.createTemplate(template).make(contextMap).toString();
    }

    public static Map<String, Object> getDefaultContextMap() {
        HashMap<String, Object> defaultContextMap = new HashMap<String, Object>();
        Instant now = Instant.now();
        defaultContextMap.put("today", DATE_FORMAT.format(new Date(now.toEpochMilli())));
        defaultContextMap.put("yesterday", DATE_FORMAT.format(new Date(now.minus(1L, ChronoUnit.DAYS).toEpochMilli())));
        return defaultContextMap;
    }

    public static Map<String, Object> getTemplateContext(List<String> values) {
        if (values == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (String value : values) {
            String[] splits = value.split("=", 2);
            if (splits.length <= 1) continue;
            context.put(splits[0], splits[1]);
        }
        return context;
    }

    public static String renderTemplate(String template) throws IOException, ClassNotFoundException {
        return GroovyTemplateUtils.renderTemplate(template, Collections.emptyMap());
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

