/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils.builder;

import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.TableType;

public class TableNameBuilder {
    public static final TableNameBuilder OFFLINE = new TableNameBuilder(TableType.OFFLINE);
    public static final TableNameBuilder REALTIME = new TableNameBuilder(TableType.REALTIME);
    private static final String TYPE_SUFFIX_SEPARATOR = "_";
    private final String _typeSuffix;

    private TableNameBuilder(TableType tableType) {
        this._typeSuffix = TYPE_SUFFIX_SEPARATOR + tableType.toString();
    }

    public static TableNameBuilder forType(TableType tableType) {
        if (tableType == TableType.OFFLINE) {
            return OFFLINE;
        }
        return REALTIME;
    }

    public String tableNameWithType(String tableName) {
        if (tableName.endsWith(this._typeSuffix)) {
            return tableName;
        }
        return tableName + this._typeSuffix;
    }

    private boolean tableHasTypeSuffix(String tableName) {
        return tableName.endsWith(this._typeSuffix);
    }

    @Nullable
    public static TableType getTableTypeFromTableName(String tableName) {
        if (OFFLINE.tableHasTypeSuffix(tableName)) {
            return TableType.OFFLINE;
        }
        if (REALTIME.tableHasTypeSuffix(tableName)) {
            return TableType.REALTIME;
        }
        return null;
    }

    public static String extractRawTableName(String tableName) {
        if (OFFLINE.tableHasTypeSuffix(tableName)) {
            return tableName.substring(0, tableName.length() - TableNameBuilder.OFFLINE._typeSuffix.length());
        }
        if (REALTIME.tableHasTypeSuffix(tableName)) {
            return tableName.substring(0, tableName.length() - TableNameBuilder.REALTIME._typeSuffix.length());
        }
        return tableName;
    }

    public static boolean isTableResource(String resourceName) {
        return OFFLINE.tableHasTypeSuffix(resourceName) || REALTIME.tableHasTypeSuffix(resourceName);
    }

    public static boolean isOfflineTableResource(String resourceName) {
        return OFFLINE.tableHasTypeSuffix(resourceName);
    }

    public static boolean isRealtimeTableResource(String resourceName) {
        return REALTIME.tableHasTypeSuffix(resourceName);
    }
}

