/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.accounting;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadResourceUsageProvider {
    private static final Logger LOGGER;
    private static final String SUN_THREAD_MXBEAN_CLASS_NAME = "com.sun.management.ThreadMXBean";
    private static final String SUN_THREAD_MXBEAN_IS_THREAD_ALLOCATED_MEMORY_SUPPORTED_NAME = "isThreadAllocatedMemorySupported";
    private static final String SUN_THREAD_MXBEAN_IS_THREAD_ALLOCATED_MEMORY_ENABLED_NAME = "isThreadAllocatedMemoryEnabled";
    private static final String SUN_THREAD_MXBEAN_SET_THREAD_ALLOCATED_MEMORY_ENABLED_NAME = "setThreadAllocatedMemoryEnabled";
    private static final String SUN_THREAD_MXBEAN_GET_BYTES_ALLOCATED_NAME = "getThreadAllocatedBytes";
    private static final Method SUN_THREAD_MXBEAN_GET_BYTES_ALLOCATED_METHOD;
    private static final ThreadMXBean MX_BEAN;
    private static final boolean IS_CURRENT_THREAD_CPU_TIME_SUPPORTED;
    private static final boolean IS_THREAD_ALLOCATED_MEMORY_SUPPORTED;
    private static final boolean IS_THREAD_ALLOCATED_MEMORY_ENABLED_DEFAULT;
    private static boolean _isThreadCpuTimeMeasurementEnabled;
    private static boolean _isThreadMemoryMeasurementEnabled;
    private final long _startTimeNs = _isThreadCpuTimeMeasurementEnabled ? MX_BEAN.getCurrentThreadCpuTime() : -1L;
    private final long _startBytesAllocated;

    public ThreadResourceUsageProvider() {
        long startBytesAllocated1;
        try {
            startBytesAllocated1 = _isThreadMemoryMeasurementEnabled ? (Long)SUN_THREAD_MXBEAN_GET_BYTES_ALLOCATED_METHOD.invoke((Object)MX_BEAN, Thread.currentThread().getId()) : -1L;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            startBytesAllocated1 = -1L;
            LOGGER.error("Exception happened during the invocation of getting initial bytes allocated", (Throwable)e);
        }
        this._startBytesAllocated = startBytesAllocated1;
    }

    public static boolean isThreadCpuTimeMeasurementEnabled() {
        return _isThreadCpuTimeMeasurementEnabled;
    }

    public static void setThreadCpuTimeMeasurementEnabled(boolean enable) {
        _isThreadCpuTimeMeasurementEnabled = enable && IS_CURRENT_THREAD_CPU_TIME_SUPPORTED;
    }

    public static boolean isThreadMemoryMeasurementEnabled() {
        return _isThreadMemoryMeasurementEnabled;
    }

    public static void setThreadMemoryMeasurementEnabled(boolean enable) {
        boolean isThreadAllocateMemoryEnabled = IS_THREAD_ALLOCATED_MEMORY_ENABLED_DEFAULT;
        if (enable != IS_THREAD_ALLOCATED_MEMORY_ENABLED_DEFAULT) {
            try {
                Class<?> sunThreadMXBeanClass = Class.forName(SUN_THREAD_MXBEAN_CLASS_NAME);
                sunThreadMXBeanClass.getMethod(SUN_THREAD_MXBEAN_SET_THREAD_ALLOCATED_MEMORY_ENABLED_NAME, Boolean.TYPE).invoke((Object)MX_BEAN, enable);
                isThreadAllocateMemoryEnabled = (Boolean)sunThreadMXBeanClass.getMethod(SUN_THREAD_MXBEAN_IS_THREAD_ALLOCATED_MEMORY_ENABLED_NAME, new Class[0]).invoke((Object)MX_BEAN, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Not able to call isThreadAllocatedMemoryEnabled or setThreadAllocatedMemoryEnabled, ", (Throwable)e);
            }
        }
        _isThreadMemoryMeasurementEnabled = enable && IS_THREAD_ALLOCATED_MEMORY_SUPPORTED && isThreadAllocateMemoryEnabled;
    }

    public long getThreadTimeNs() {
        return _isThreadCpuTimeMeasurementEnabled ? MX_BEAN.getCurrentThreadCpuTime() - this._startTimeNs : 0L;
    }

    public long getThreadAllocatedBytes() {
        try {
            return _isThreadMemoryMeasurementEnabled ? (Long)SUN_THREAD_MXBEAN_GET_BYTES_ALLOCATED_METHOD.invoke((Object)MX_BEAN, Thread.currentThread().getId()) - this._startBytesAllocated : 0L;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("Exception happened during the invocation of getting initial bytes allocated", (Throwable)e);
            return 0L;
        }
    }

    static {
        Class<?> sunThreadMXBeanClass;
        LOGGER = LoggerFactory.getLogger(ThreadResourceUsageProvider.class);
        MX_BEAN = ManagementFactory.getThreadMXBean();
        IS_CURRENT_THREAD_CPU_TIME_SUPPORTED = MX_BEAN.isCurrentThreadCpuTimeSupported();
        _isThreadCpuTimeMeasurementEnabled = false;
        _isThreadMemoryMeasurementEnabled = false;
        try {
            sunThreadMXBeanClass = Class.forName(SUN_THREAD_MXBEAN_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Not able to load com.sun.management.ThreadMXBean, you are probably not using Hotspot jvm");
            sunThreadMXBeanClass = null;
        }
        boolean isThreadAllocateMemorySupported = false;
        try {
            isThreadAllocateMemorySupported = sunThreadMXBeanClass != null && (Boolean)sunThreadMXBeanClass.getMethod(SUN_THREAD_MXBEAN_IS_THREAD_ALLOCATED_MEMORY_SUPPORTED_NAME, new Class[0]).invoke((Object)MX_BEAN, new Object[0]) != false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Not able to call isThreadAllocatedMemorySupported, ", (Throwable)e);
        }
        IS_THREAD_ALLOCATED_MEMORY_SUPPORTED = isThreadAllocateMemorySupported;
        boolean isThreadAllocateMemoryEnabled = false;
        try {
            isThreadAllocateMemoryEnabled = sunThreadMXBeanClass != null && (Boolean)sunThreadMXBeanClass.getMethod(SUN_THREAD_MXBEAN_IS_THREAD_ALLOCATED_MEMORY_ENABLED_NAME, new Class[0]).invoke((Object)MX_BEAN, new Object[0]) != false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("Not able to call isThreadAllocatedMemoryEnabled, ", (Throwable)e);
        }
        IS_THREAD_ALLOCATED_MEMORY_ENABLED_DEFAULT = isThreadAllocateMemoryEnabled;
        Method threadAllocateBytes = null;
        if (IS_THREAD_ALLOCATED_MEMORY_SUPPORTED) {
            try {
                threadAllocateBytes = sunThreadMXBeanClass.getMethod(SUN_THREAD_MXBEAN_GET_BYTES_ALLOCATED_NAME, Long.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        SUN_THREAD_MXBEAN_GET_BYTES_ALLOCATED_METHOD = threadAllocateBytes;
        LOGGER.info("Current thread cpu time measurement supported: {}", (Object)IS_CURRENT_THREAD_CPU_TIME_SUPPORTED);
        LOGGER.info("Current thread allocated bytes measurement supported: {}", (Object)IS_THREAD_ALLOCATED_MEMORY_SUPPORTED);
        LOGGER.info("Current thread allocated bytes measurement enabled default: {}", (Object)IS_THREAD_ALLOCATED_MEMORY_ENABLED_DEFAULT);
    }
}

