/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.TimestampConfig;

public class FieldConfig
extends BaseJsonConfig {
    public static final String BLOOM_FILTER_COLUMN_KEY = "createBloomFilter";
    public static final String ON_HEAP_DICTIONARY_COLUMN_KEY = "useOnHeapDictionary";
    public static final String VAR_LENGTH_DICTIONARY_COLUMN_KEY = "useVarLengthDictionary";
    public static final String DERIVE_NUM_DOCS_PER_CHUNK_RAW_INDEX_KEY = "deriveNumDocsPerChunkForRawIndex";
    public static final String RAW_INDEX_WRITER_VERSION = "rawIndexWriterVersion";
    public static final String IS_SEGMENT_PARTITIONED_COLUMN_KEY = "isSegmentPartitioned";
    public static final String TEXT_INDEX_REALTIME_READER_REFRESH_KEY = "textIndexRealtimeReaderRefreshThreshold";
    public static final String TEXT_INDEX_ENABLE_QUERY_CACHE = "enableQueryCacheForTextIndex";
    public static final String TEXT_INDEX_USE_AND_FOR_MULTI_TERM_QUERIES = "useANDForMultiTermTextIndexQueries";
    public static final String TEXT_INDEX_NO_RAW_DATA = "noRawDataForTextIndex";
    public static final String TEXT_INDEX_RAW_VALUE = "rawValueForTextIndex";
    public static final String TEXT_INDEX_DEFAULT_RAW_VALUE = "n";
    public static final String TEXT_INDEX_STOP_WORD_INCLUDE_KEY = "stopWordInclude";
    public static final String TEXT_INDEX_STOP_WORD_EXCLUDE_KEY = "stopWordExclude";
    public static final String TEXT_INDEX_LUCENE_USE_COMPOUND_FILE = "luceneUseCompoundFile";
    public static final String TEXT_INDEX_LUCENE_MAX_BUFFER_SIZE_MB = "luceneMaxBufferSizeMB";
    public static final String TEXT_INDEX_STOP_WORD_SEPERATOR = ",";
    public static final String TEXT_FST_TYPE = "fstType";
    public static final String TEXT_NATIVE_FST_LITERAL = "native";
    public static final String FORWARD_INDEX_DISABLED = "forwardIndexDisabled";
    public static final String DEFAULT_FORWARD_INDEX_DISABLED = Boolean.FALSE.toString();
    private final String _name;
    private final EncodingType _encodingType;
    private final List<IndexType> _indexTypes;
    private final JsonNode _indexes;
    private final JsonNode _tierOverwrites;
    private final CompressionCodec _compressionCodec;
    private final Map<String, String> _properties;
    private final TimestampConfig _timestampConfig;

    @Deprecated
    public FieldConfig(String name, EncodingType encodingType, IndexType indexType, CompressionCodec compressionCodec, Map<String, String> properties) {
        this(name, encodingType, indexType, null, compressionCodec, null, null, properties, null);
    }

    public FieldConfig(String name, EncodingType encodingType, List<IndexType> indexTypes, CompressionCodec compressionCodec, Map<String, String> properties) {
        this(name, encodingType, null, indexTypes, compressionCodec, null, null, properties, null);
    }

    @Deprecated
    public FieldConfig(String name, EncodingType encodingType, @Nullable IndexType indexType, @Nullable List<IndexType> indexTypes, @Nullable CompressionCodec compressionCodec, @Nullable TimestampConfig timestampConfig, @Nullable Map<String, String> properties) {
        this(name, encodingType, indexType, indexTypes, compressionCodec, timestampConfig, null, properties, null);
    }

    @JsonCreator
    public FieldConfig(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="encodingType") EncodingType encodingType, @JsonProperty(value="indexType") @Nullable IndexType indexType, @JsonProperty(value="indexTypes") @Nullable List<IndexType> indexTypes, @JsonProperty(value="compressionCodec") @Nullable CompressionCodec compressionCodec, @JsonProperty(value="timestampConfig") @Nullable TimestampConfig timestampConfig, @JsonProperty(value="indexes") @Nullable JsonNode indexes, @JsonProperty(value="properties") @Nullable Map<String, String> properties, @JsonProperty(value="tierOverwrites") @Nullable JsonNode tierOverwrites) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"'name' must be configured");
        this._name = name;
        this._encodingType = encodingType;
        this._indexTypes = indexTypes != null ? indexTypes : (indexType == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new IndexType[]{indexType}));
        this._compressionCodec = compressionCodec;
        this._timestampConfig = timestampConfig;
        this._properties = properties;
        this._indexes = indexes == null ? NullNode.getInstance() : indexes;
        this._tierOverwrites = tierOverwrites == null ? NullNode.getInstance() : tierOverwrites;
    }

    public String getName() {
        return this._name;
    }

    public EncodingType getEncodingType() {
        return this._encodingType;
    }

    @Nullable
    @Deprecated
    public IndexType getIndexType() {
        return this._indexTypes.size() > 0 ? this._indexTypes.get(0) : null;
    }

    public List<IndexType> getIndexTypes() {
        return this._indexTypes;
    }

    public JsonNode getIndexes() {
        return this._indexes;
    }

    public JsonNode getTierOverwrites() {
        return this._tierOverwrites;
    }

    @Nullable
    public CompressionCodec getCompressionCodec() {
        return this._compressionCodec;
    }

    @Nullable
    public TimestampConfig getTimestampConfig() {
        return this._timestampConfig;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this._properties;
    }

    public static class Builder {
        @Nonnull
        private String _name;
        private EncodingType _encodingType;
        private List<IndexType> _indexTypes;
        private JsonNode _indexes;
        private CompressionCodec _compressionCodec;
        private Map<String, String> _properties;
        private TimestampConfig _timestampConfig;
        private JsonNode _tierOverwrites;

        public Builder(@Nonnull String name) {
            this._name = name;
        }

        public Builder(FieldConfig other) {
            this._name = other._name;
            this._encodingType = other._encodingType;
            this._indexTypes = other._indexTypes;
            this._indexes = other._indexes;
            this._compressionCodec = other._compressionCodec;
            this._properties = other._properties;
            this._timestampConfig = other._timestampConfig;
            this._tierOverwrites = other._tierOverwrites;
        }

        public Builder withIndexes(JsonNode indexes) {
            this._indexes = indexes;
            return this;
        }

        public Builder withName(String name) {
            this._name = name;
            return this;
        }

        public Builder withEncodingType(EncodingType encodingType) {
            this._encodingType = encodingType;
            return this;
        }

        public Builder withIndexTypes(List<IndexType> indexTypes) {
            this._indexTypes = indexTypes;
            return this;
        }

        public Builder withCompressionCodec(CompressionCodec compressionCodec) {
            this._compressionCodec = compressionCodec;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this._properties = properties;
            return this;
        }

        public Builder withTimestampConfig(TimestampConfig timestampConfig) {
            this._timestampConfig = timestampConfig;
            return this;
        }

        public Builder withTierOverwrites(JsonNode tierOverwrites) {
            this._tierOverwrites = tierOverwrites;
            return this;
        }

        public FieldConfig build() {
            return new FieldConfig(this._name, this._encodingType, null, this._indexTypes, this._compressionCodec, this._timestampConfig, this._indexes, this._properties, this._tierOverwrites);
        }
    }

    public static enum CompressionCodec {
        PASS_THROUGH,
        SNAPPY,
        ZSTANDARD,
        LZ4;

    }

    public static enum IndexType {
        INVERTED,
        SORTED,
        TEXT,
        FST,
        H3,
        JSON,
        TIMESTAMP,
        RANGE;

    }

    public static enum EncodingType {
        RAW,
        DICTIONARY;

    }
}

