/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.IndexConfig;

public class JsonIndexConfig
extends IndexConfig {
    public static final JsonIndexConfig DISABLED = new JsonIndexConfig(true);
    private int _maxLevels = -1;
    private boolean _excludeArray = false;
    private boolean _disableCrossArrayUnnest = false;
    private Set<String> _includePaths;
    private Set<String> _excludePaths;
    private Set<String> _excludeFields;

    public JsonIndexConfig() {
        super(false);
    }

    public JsonIndexConfig(Boolean disabled) {
        super(disabled);
    }

    @JsonCreator
    public JsonIndexConfig(@JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="maxLevels") int maxLevels, @JsonProperty(value="excludeArray") boolean excludeArray, @JsonProperty(value="disableCrossArrayUnnest") boolean disableCrossArrayUnnest, @JsonProperty(value="includePaths") @Nullable Set<String> includePaths, @JsonProperty(value="excludePaths") @Nullable Set<String> excludePaths, @JsonProperty(value="excludeFields") @Nullable Set<String> excludeFields) {
        super(disabled);
        this._maxLevels = maxLevels;
        this._excludeArray = excludeArray;
        this._disableCrossArrayUnnest = disableCrossArrayUnnest;
        this._includePaths = includePaths;
        this._excludePaths = excludePaths;
        this._excludeFields = excludeFields;
    }

    public int getMaxLevels() {
        return this._maxLevels;
    }

    public void setMaxLevels(int maxLevels) {
        this._maxLevels = maxLevels;
    }

    public boolean isExcludeArray() {
        return this._excludeArray;
    }

    public void setExcludeArray(boolean excludeArray) {
        this._excludeArray = excludeArray;
    }

    public boolean isDisableCrossArrayUnnest() {
        return this._disableCrossArrayUnnest;
    }

    public void setDisableCrossArrayUnnest(boolean disableCrossArrayUnnest) {
        this._disableCrossArrayUnnest = disableCrossArrayUnnest;
    }

    @Nullable
    public Set<String> getIncludePaths() {
        return this._includePaths;
    }

    public void setIncludePaths(@Nullable Set<String> includePaths) {
        Preconditions.checkArgument((includePaths == null || this._excludePaths == null ? 1 : 0) != 0, (Object)"Cannot configure both include and exclude paths");
        Preconditions.checkArgument((includePaths == null || includePaths.size() > 0 ? 1 : 0) != 0, (Object)"Include paths cannot be empty");
        this._includePaths = includePaths;
    }

    @Nullable
    public Set<String> getExcludePaths() {
        return this._excludePaths;
    }

    public void setExcludePaths(@Nullable Set<String> excludePaths) {
        Preconditions.checkArgument((excludePaths == null || this._includePaths == null ? 1 : 0) != 0, (Object)"Cannot configure both include and exclude paths");
        this._excludePaths = excludePaths;
    }

    @Nullable
    public Set<String> getExcludeFields() {
        return this._excludeFields;
    }

    public void setExcludeFields(@Nullable Set<String> excludeFields) {
        this._excludeFields = excludeFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonIndexConfig config = (JsonIndexConfig)o;
        return this._maxLevels == config._maxLevels && this._excludeArray == config._excludeArray && this._disableCrossArrayUnnest == config._disableCrossArrayUnnest && Objects.equals(this._includePaths, config._includePaths) && Objects.equals(this._excludePaths, config._excludePaths) && Objects.equals(this._excludeFields, config._excludeFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._maxLevels, this._excludeArray, this._disableCrossArrayUnnest, this._includePaths, this._excludePaths, this._excludeFields);
    }
}

