/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table.assignment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class InstanceReplicaGroupPartitionConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Whether to use replica-group based selection, false by default")
    private final boolean _replicaGroupBased;
    @JsonPropertyDescription(value="Number of instances to select for non-replica-group based selection, select all instances if not specified")
    private final int _numInstances;
    @JsonPropertyDescription(value="Number of replica-groups for replica-group based selection")
    private final int _numReplicaGroups;
    @JsonPropertyDescription(value="Number of instances per replica-group for replica-group based selection, select as many instances as possible if not specified")
    private final int _numInstancesPerReplicaGroup;
    @JsonPropertyDescription(value="Number of partitions for replica-group based selection, do not partition the replica-group (1 partition) if not specified")
    private final int _numPartitions;
    @JsonPropertyDescription(value="Number of instances per partition (within a replica-group) for replica-group based selection, select all instances if not specified")
    private final int _numInstancesPerPartition;
    @JsonPropertyDescription(value="Name of the column used for partition, if not provided table level replica group will be used")
    private final String _partitionColumn;
    private final boolean _minimizeDataMovement;

    @JsonCreator
    public InstanceReplicaGroupPartitionConfig(@JsonProperty(value="replicaGroupBased") boolean replicaGroupBased, @JsonProperty(value="numInstances") int numInstances, @JsonProperty(value="numReplicaGroups") int numReplicaGroups, @JsonProperty(value="numInstancesPerReplicaGroup") int numInstancesPerReplicaGroup, @JsonProperty(value="numPartitions") int numPartitions, @JsonProperty(value="numInstancesPerPartition") int numInstancesPerPartition, @JsonProperty(value="minimizeDataMovement") boolean minimizeDataMovement, @Nullable @JsonProperty(value="partitionColumn") String partitionColumn) {
        this._replicaGroupBased = replicaGroupBased;
        this._numInstances = numInstances;
        this._numReplicaGroups = numReplicaGroups;
        this._numInstancesPerReplicaGroup = numInstancesPerReplicaGroup;
        this._numPartitions = numPartitions;
        this._numInstancesPerPartition = numInstancesPerPartition;
        this._minimizeDataMovement = minimizeDataMovement;
        this._partitionColumn = partitionColumn;
    }

    public boolean isReplicaGroupBased() {
        return this._replicaGroupBased;
    }

    public int getNumInstances() {
        return this._numInstances;
    }

    public int getNumReplicaGroups() {
        return this._numReplicaGroups;
    }

    public int getNumInstancesPerReplicaGroup() {
        return this._numInstancesPerReplicaGroup;
    }

    public int getNumPartitions() {
        return this._numPartitions;
    }

    public int getNumInstancesPerPartition() {
        return this._numInstancesPerPartition;
    }

    public boolean isMinimizeDataMovement() {
        return this._minimizeDataMovement;
    }

    @Nullable
    public String getPartitionColumn() {
        return this._partitionColumn;
    }
}

