/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table.ingestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class SchemaConformingTransformerConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Name of the field that should contain extra fields that are not part of the schema.")
    private final String _indexableExtrasField;
    @JsonPropertyDescription(value="Like indexableExtrasField except it only contains fields with the suffix in unindexableFieldSuffix.")
    private final String _unindexableExtrasField;
    @JsonPropertyDescription(value="The suffix of fields that must be stored in unindexableExtrasField")
    private final String _unindexableFieldSuffix;
    @JsonPropertyDescription(value="Array of field paths to drop")
    private final Set<String> _fieldPathsToDrop;

    @JsonCreator
    public SchemaConformingTransformerConfig(@JsonProperty(value="indexableExtrasField") String indexableExtrasField, @JsonProperty(value="unindexableExtrasField") @Nullable String unindexableExtrasField, @JsonProperty(value="unindexableFieldSuffix") @Nullable String unindexableFieldSuffix, @JsonProperty(value="fieldPathsToDrop") @Nullable Set<String> fieldPathsToDrop) {
        Preconditions.checkArgument((indexableExtrasField != null ? 1 : 0) != 0, (Object)"indexableExtrasField must be set");
        if (null != unindexableExtrasField) {
            Preconditions.checkArgument((null != unindexableFieldSuffix ? 1 : 0) != 0, (Object)"unindexableExtrasSuffix must be set if unindexableExtrasField is set");
        }
        this._indexableExtrasField = indexableExtrasField;
        this._unindexableExtrasField = unindexableExtrasField;
        this._unindexableFieldSuffix = unindexableFieldSuffix;
        this._fieldPathsToDrop = fieldPathsToDrop;
    }

    public String getIndexableExtrasField() {
        return this._indexableExtrasField;
    }

    @Nullable
    public String getUnindexableExtrasField() {
        return this._unindexableExtrasField;
    }

    @Nullable
    public String getUnindexableFieldSuffix() {
        return this._unindexableFieldSuffix;
    }

    @Nullable
    public Set<String> getFieldPathsToDrop() {
        return this._fieldPathsToDrop;
    }
}

